# approved by zhur
# добавляем client_domains вместо client_urls для CRM
# база данных: monitor
# когда нужно выполнить: до выкладки без остановки интерфейса
# примерное время выполнения: 46 сек

CREATE TABLE client_domains (
  `record_id` int(10) unsigned NOT NULL auto_increment,
  `ClientID` int(10) unsigned NOT NULL default '0',
  `domain` varchar(255) NOT NULL,
  `removed` tinyint(4) NOT NULL default '0',
  `logtime` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `camp_type` enum('text','mcb') NOT NULL default 'text',
  PRIMARY KEY  (`record_id`),
  UNIQUE KEY `ClientID` (`ClientID`,`domain`, `camp_type`),
  KEY `logtime` (`logtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

insert into client_domains (ClientID, domain, record_id, removed, logtime, camp_type)
select ClientID, domain, record_id, removed, logtime, camp_type
from client_urls
group by ClientID, domain, camp_type;

# on devtest:
# Query OK, 400247 rows affected (46.08 sec)
# Records: 400247  Duplicates: 0  Warnings: 0
