#!/usr/bin/perl

# approved by zhur
# https://jira.yandex-team.ru/browse/DIRECT-10666
# проставляем на существующих агентствах менеджеров в таблице clients
# выполнять после выкладки
# выполнять на ppc

use warnings;
use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use E;
use Yandex::Log;
use List::MoreUtils qw/uniq/;
use Data::Dumper;

#-----------------------------------------------------------
sub main
{
    my $log = Yandex::Log->new(log_file_name => '20110210_set_managers_on_agencies.log');

    my $default_geo_manager = get_uid_by_login('yndx.geomanager') or die "yndx.geomanager not found";
    my %is_geo_ag = get_geo_agencies();
    $log->out({all_geo_agencies => \%is_geo_ag});

    for my $AgencyID (sort {$a <=> $b} get_all_agencies()) {

        my $exist_managers = get_one_line_sql(PPC, "select primary_manager_uid, primary_bayan_manager_uid from clients where ClientID = ?", $AgencyID) || {};
        $log->out({AgencyID => $AgencyID, exist_managers => $exist_managers});

        my $need_update_agency;

        if ($is_geo_ag{$AgencyID}) {
            $exist_managers->{primary_geo_manager_uid} = $default_geo_manager;
            $need_update_agency = 1;
        }

        my @managers = grep {$_ != $default_geo_manager} @{rbac_get_all_managers_of_agency_clientid($rbac, $AgencyID)};

        my %camp_types = map {$_->{type} => $_->{cnt}}
                         @{get_all_sql(PPC, "select type, count(*) as cnt
                                             from campaigns c
                                               join users u on c.AgencyUID = u.uid
                                             where u.ClientID = ?
                                               and c.statusEmpty = 'No'
                                             group by c.type
                                            ", $AgencyID)};

        # если есть директ. и mcb-кампании и есть 2 менеджера (без yndx.geomanager), то пропускаем таких, их нужно апдейтить вручную
        if ($camp_types{text} && $camp_types{mcb} && scalar(@managers) > 1) {
            $log->out({skip_agency_with_many_managers => 1, AgencyID => $AgencyID, types => \%camp_types, managers => \@managers});
            print "skip agency with many managers, AgencyID => $AgencyID\n";
            next;
        }

        if (scalar(@managers) == 1) {
            if ($camp_types{text} && ! $camp_types{mcb} && ! $exist_managers->{primary_manager_uid}) {
                $exist_managers->{primary_manager_uid} = $managers[0];
                $need_update_agency = 1;
            } elsif (! $camp_types{text} && $camp_types{mcb} && ! $exist_managers->{primary_bayan_manager_uid}) {
                $exist_managers->{primary_bayan_manager_uid} = $managers[0];
                $need_update_agency = 1;
            }
        }

        if ($need_update_agency) {
            my $cnt = do_update_table(PPC, 'clients', $exist_managers, where => {ClientID => $AgencyID});
            $log->out({do_update_table => $cnt, new_managers => $exist_managers, AgencyID => $AgencyID});
        } else {
            $log->out({do_not_update_table => 1, AgencyID => $AgencyID});
        }
    }
}

#-----------------------------------------------------------
sub get_geo_agencies
{
    my %geo_ag;
    while (my $line = <DATA>) {
        next unless $line =~ /^ \s* \| \s* (\d+) \s* \| [^\|]+ \|/x;
        $geo_ag{$1}++;
    }
    return %geo_ag;
}

#-----------------------------------------------------------
sub get_all_agencies
{
    my @all_agencies = uniq values %{ rbac_get_agencies_clientids_by_uids( rbac_get_all_agencies($rbac)) };
    return @all_agencies;
}

#-----------------------------------------------------------
main();

__DATA__
+-----------+-----------------------+
| client_id | login                 |
+-----------+-----------------------+
|    412576 | vdundik               |
|    619561 | lazuka                |
|    351573 | zhur-ag2              |
|    313335 | i-media               |
|      6047 | mibokru               |
|    383222 | i-matrix              |
|    370879 | Ashmanov1919          |
|    368806 | hotkeyru              |
|    510176 | reklama-voskresensk   |
|    563669 | arneostudio           |
|    869777 | online-soft-mari      |
|    949434 | webprofiters          |
|    956981 | rsftru                |
|    905890 | ra-mostdirect         |
|   1123330 | smartmd               |
|   1093414 | balakinan-agtest      |
|   1239068 | ecosoft-tyumen        |
|   1490794 | partners-id-yellpages |
|   1490796 | partners-twinmedia    |
|   1487503 | partners-allvrn       |
|   1490771 | partners-ivolga       |
|   1490578 | partners-twins        |
|   1490764 | partners-vseivanovo   |
|   1490773 | partners-yarcom       |
|   1490744 | partners-remark       |
|   1491510 | partners-satellite    |
|   1490780 | partners-Irk223       |
|   1490787 | partners-norma        |
|   1490808 | partners-yp40         |
|   1490767 | partners-sam5         |
|   1490790 | partners-id-ksp       |
|   1490810 | partners-delsaransk   |
|   1490792 | partners.allo         |
|   1490812 | partners-bis007       |
|   1494970 | partners.allinform    |
+-----------+-----------------------+
