#!/usr/bin/perl

# approved by lena-san
# Исправляем записи в таблице логов и удаляем пустые геокампании
# Скрипт запускать с сервера ppc из-под пользователя ppc после выполнения sql-миграции
# perl /var/www/ppc.yandex.ru/deploy/20110301_fix_geo_camps.pl
# ожидаемое время исполнения: примерно 30 секунд

use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/../protected";
use Settings;
use DBTools;
use ScriptHelper;

# join нужен, т.к. есть много пустых кампаний без баннеров -- баг в геоконтексте, исправленный не сразу
my $bad_geo_cids = get_one_column_sql(PPC_HEAVY, 'select cid from campaigns left join banners using (cid) join camp_options using (cid) where type = "geo" and create_time < "2011-03-01" and bid is NULL');
# прибиваем эти пустые кампании
do_sql(PPC, ['delete from campaigns', where => {cid => $bad_geo_cids}]);
$log->out({bad_geo_cids => $bad_geo_cids});

my $good_geo_cids = get_one_column_sql(PPC, 'select cid from campaigns where type = "geo"');
# дописываем тип, потерянный из-за неправильного enum в описании таблицы
do_update_table(PPCLOG, 'logbalance', {type => 'geo'}, where => {cid => $good_geo_cids});
$log->out({good_geo_cids => $good_geo_cids});
