#!/usr/bin/perl

# approved by zhur
# https://jira.yandex-team.ru/browse/DIRECT-10666
# https://jira.yandex-team.ru/browse/DIRECT-10942
# проставляем на существующих агентствах менеджеров в таблице clients
# выполнять после выкладки
# выполнять на ppc

use warnings;
use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use E;
use Yandex::Log;
use List::MoreUtils qw/uniq/;
use Data::Dumper;
use Yandex::HashUtils;

our $default_geo_manager = get_uid_by_login('yndx.geomanager') or die "yndx.geomanager not found";
our $log = Yandex::Log->new(log_file_name => '20110316_set_managers_on_agencies.log');

#-----------------------------------------------------------
sub main
{
    for my $AgencyID (sort {$a <=> $b} get_all_agencies_without_managers()) {

        my $exist_managers = get_one_line_sql(PPC, "select primary_manager_uid, primary_bayan_manager_uid, primary_geo_manager_uid from clients where ClientID = ?", $AgencyID) || {};

        my $need_update_agency;

        my $rbac_managers = rbac_get_all_managers_of_agency_clientid($rbac, $AgencyID);
        my @managers = grep {$_ != $default_geo_manager} @{$rbac_managers};

        my %camp_types = map {$_->{type} => $_->{cnt}}
                         @{get_all_sql(PPC, "select type, count(*) as cnt
                                             from campaigns c
                                               join users u on c.AgencyUID = u.uid
                                             where u.ClientID = ?
                                               and c.statusEmpty = 'No'
                                             group by c.type
                                            ", $AgencyID)};

        my $log_out = {AgencyID => $AgencyID, old_exist_managers => {%$exist_managers}, rbac_managers => $rbac_managers, rbac_man_count => scalar(@$rbac_managers), camp_types => \%camp_types};

        # если есть директ. и mcb-кампании и есть 2 менеджера (без yndx.geomanager), то пропускаем таких, их нужно апдейтить вручную
        if (scalar(@managers) > 1) {
            hash_merge $log_out, {skip_agency_with_many_managers => 1, AgencyID => $AgencyID, managers => \@managers};
            print "skip agency with many managers, AgencyID => $AgencyID\n";
        } elsif (scalar(@managers) == 0) {
            hash_merge $log_out, {agency_without_managers_skip => 1};
        } elsif (scalar(@managers) == 1) {
            if ($camp_types{text} && ! $camp_types{mcb} && ! $exist_managers->{primary_manager_uid}) {
                $exist_managers->{primary_manager_uid} = $managers[0];
                $need_update_agency = 1;
            } elsif (! $camp_types{text} && $camp_types{mcb} && ! $exist_managers->{primary_bayan_manager_uid}) {
                $exist_managers->{primary_bayan_manager_uid} = $managers[0];
                $need_update_agency = 1;
            } else {
                $exist_managers->{primary_manager_uid} = $managers[0];
                $need_update_agency = 1;
            }
        }

        if ($need_update_agency) {
            my $cnt = do_update_table(PPC, 'clients', $exist_managers, where => {ClientID => $AgencyID});
            hash_merge $log_out, {do_update_table => $cnt, new_managers => {%$exist_managers}, AgencyID => $AgencyID};
        } else {
            hash_merge $log_out, {do_not_update_table => 1, AgencyID => $AgencyID};
        }

        $log->out($log_out);
    }
}

#-----------------------------------------------------------
sub get_all_agencies_without_managers
{
    my $all_uids = join ',', @{rbac_get_all_agencies($rbac)};
    my $ag = get_all_sql(PPC, "select distinct cl.ClientID
                               from clients cl
                               join users u using(ClientID)
                               where primary_manager_uid is null
                                 and primary_bayan_manager_uid is null
                                 and primary_geo_manager_uid is null
                                 and u.uid in ($all_uids)
                              ");

    return map {$_->{ClientID}} @$ag;
}

#-----------------------------------------------------------
main();
