#!/usr/bin/perl
# approved by zhur
# заполняем noвое поле в monitor.agency_clients_month_stat - banners_moderate (кол-во уникальных баннеров прошедших через модерацию на клиенте за период)
# выполнять: после выкладки в любое время (после применения deploy/20110324_monitor_add_modbanners_agency_clients_month_stat.sql)
# на devtest выполнялся около 30 минут

# начинаем с прошлого квартала (c 2010-10-01)

use warnings;
use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use E;
use ReportsOffline;
use Yandex::DateTime;
use Yandex::Log;

#-----------------------------------------------------------
sub main
{
    my $log = Yandex::Log->new(log_file_name => '20110324_fill_new_agency_clients_month_stat.log', date_suf => '');

    $log->out("script start");

    my $exists_clients = get_all_sql(MONITOR,
        "select distinct AgencyID, ClientID, stat_date
         from agency_clients_month_stat
         where stat_date >= '2010-10-01'
         order by stat_date
        "
    );
    $log->out("clients count: " . scalar(@$exists_clients));

    my $cnt = 0;
    for my $row (@$exists_clients) {
        my ($date_from, $date_to) = ReportsOffline::get_first_n_last_date_of_month(date($row->{stat_date}));
        my $cids = get_active_cids($row->{AgencyID}, $row->{ClientID}, $date_from);
        next unless @$cids;

        my ($banners_moderate, $banners_moderate_declined) = ReportsOffline::get_moderate_declined_banners($cids, $date_from, $date_to);

        $cnt += do_update_table(MONITOR, 'agency_clients_month_stat'
                                       , {banners_moderate => $banners_moderate, banners_moderate_declined => $banners_moderate_declined}
                                       , where => {AgencyID => $row->{AgencyID}
                                                 , ClientID => $row->{ClientID}
                                                 , stat_date => $row->{stat_date}
                                                  }
                               );
    }

    $log->out("clients update count: $cnt");
    $log->out("script finish");
}

#-----------------------------------------------------------
sub get_active_cids
{
    my $AgencyID = shift;
    my $ClientID = shift;
    my $date_from = shift;

    return get_one_column_sql(PPC, "select cid
                                    from campaigns c
                                      join users u using(uid)
                                      join users ua on ua.uid = c.AgencyUID
                                    where OrderID > 0
                                      and type = 'text'
                                      and u.ClientID = ?
                                      and ua.ClientID = ?
                                      and lastShowTime >= ?
                                   ", $ClientID, $AgencyID, $date_from) || [];
}

#-----------------------------------------------------------
main();
