#!/usr/bin/perl

# approved by zhur
# https://jira.yandex-team.ru/browse/DIRECT-10666
# https://jira.yandex-team.ru/browse/DIRECT-10942
# проставляем на существующих агентствах менеджеров в таблице clients
# выполнять после выкладки
# выполнять на ppc

use warnings;
use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use E;
use Yandex::Log;
use List::MoreUtils qw/uniq/;
use Data::Dumper;
use Yandex::HashUtils;

our $default_geo_manager = get_uid_by_login('yndx.geomanager') or die "yndx.geomanager not found";
our $log = Yandex::Log->new(log_file_name => '20110401_set_managers_on_agencies.log');
our %geo_agencies = map {$_ => 1} (
    412576,1845,351573,48892,50537,6047
    ,358864,367773,368724,372161,383071,370879
    ,385346,387341,398867,414530,402688,475089,409493
    ,411616,415210,368806,447851,462141,467464,470519
    ,479082,484424,497768,527007,525766,548188,563294
    ,563669,790226,807659,863824,869777,1,969916,949434,976945
    ,995337,1041590,905890,1060499,1557479,1105426,1123330,1266875,1206166,472729
    ,1093414,1239068,1221323,1109089,921681,1262257
    ,1279574,1299977,1306469,1323129,1368365,1371986,513006,947954,394725,862600
    ,1436076,1437694,1498006,321601,1119919,1490794,1490796,1487503,1490771
    ,1490578,1490764,1490773,1490744,1491510,1490780,1490787,1490808,1490767,1490790
    ,1490810,1490792,1490812,1529194,1494970,1498008,956981,1537405
    ,1538224,1541882,1557669,1549037,1550725,1558742,1563590
);

#-----------------------------------------------------------
sub main
{
    my %agencies = get_all_agencies_without_managers();

    for my $AgencyID (sort {$a <=> $b} keys %agencies) {

        my $create_date = $agencies{$AgencyID};
        my $exist_managers = {};
        my $need_update_agency;

        my $rbac_managers = rbac_get_all_managers_of_agency_clientid($rbac, $AgencyID);
        my @managers = grep {$_ != $default_geo_manager} @{$rbac_managers};

        my %camp_types = map {$_->{type} => $_->{cnt}}
                         @{get_all_sql(PPC, "select type, count(*) as cnt
                                             from campaigns c
                                               join users u on c.AgencyUID = u.uid
                                             where u.ClientID = ?
                                               and c.statusEmpty = 'No'
                                             group by c.type
                                            ", $AgencyID)};

        my $log_out = {AgencyID => $AgencyID, rbac_managers => $rbac_managers, rbac_man_count => scalar(@$rbac_managers), camp_types => \%camp_types};

        # если есть директ. и mcb-кампании и есть 2 менеджера (без yndx.geomanager), то пропускаем таких, их нужно апдейтить вручную
        if (scalar(@managers) > 1) {
            hash_merge $log_out, {skip_agency_with_many_managers => 1, AgencyID => $AgencyID, managers => \@managers};
            print "skip agency with many managers, AgencyID => $AgencyID\n";
        } elsif (scalar(@$rbac_managers) == 0) {
            hash_merge $log_out, {agency_without_managers_skip => 1};
        } elsif (scalar(@managers) == 1) {
            if ($camp_types{text} && ! $camp_types{mcb}) {
                $exist_managers->{primary_manager_uid} = $managers[0];
                $need_update_agency = 1;
            } elsif (! $camp_types{text} && $camp_types{mcb}) {
                $exist_managers->{primary_bayan_manager_uid} = $managers[0];
                $need_update_agency = 1;
            } else {
                $exist_managers->{primary_manager_uid} = $managers[0];
                $need_update_agency = 1;
            }
        }

        if ($geo_agencies{$AgencyID}) {
            $exist_managers->{primary_geo_manager_uid} = $default_geo_manager;
            $need_update_agency = 1;
        }

        if ($need_update_agency) {
            my $cnt = do_insert_into_table(PPC, 'clients', {%$exist_managers, ClientID => $AgencyID, create_date => $create_date});
            hash_merge $log_out, {do_insert_table => $cnt, new_managers => {%$exist_managers}, AgencyID => $AgencyID, create_date => $create_date};
        } else {
            hash_merge $log_out, {do_not_insert_table => 1, AgencyID => $AgencyID};
        }

        $log->out($log_out);
    }
}

#-----------------------------------------------------------
sub get_all_agencies_without_managers
{
    my $all_uids = join ',', @{rbac_get_all_agencies($rbac)};
    my $ag = get_all_sql(PPC, "select u.ClientID, min(from_unixtime(u.createtime)) as dd
                               from users u
                                 left join clients cl using(ClientID)
                               where cl.ClientID is null
                                 and u.uid in ($all_uids)
                               group by u.ClientID
                              ");

    return map {$_->{ClientID} => $_->{dd}} @$ag;
}

#-----------------------------------------------------------
main();
