#!/usr/bin/perl

# approved by lena-san
# заполняет новую таблицу логов API для ускорения внутренних отчетов
# когда выполнять: после выкладки
# примерное время выполнения: 30-40 минут
# выполнять на ppc

use warnings;
use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use DBTools;
use DBSchema;
use Yandex::TimeCommon;
use ScriptHelper;

use Data::Dumper;

use POSIX;

my $start_date = mysql2unix('2010-04-01');
my $end_date = mysql2unix( strftime("%Y-%m-%d", localtime() ) );

my @dates = ts_get_distinct_dates($start_date, $end_date);

$log->out("start copying data");

foreach my $date (@dates) {

    my $insert = [];

    my $table_name = "logapi_$date";

    $log->out("start processing $table_name");

    eval {
        my $data = get_one_column_sql(PPCLOG, "select distinct uid from $table_name");
        foreach my $uid (@$data) {
            push @$insert, [$uid, 0, $date, 1];
        }
    };

    my $table_date_month = substr($date, 0, 6);

    eval {
        do_mass_insert_sql(PPCLOG, "insert into logapi_users_$table_date_month (operator_uid, client_uid, date, cnt)
                                    values %s 
                                    ", $insert);
    };

    if ( $@ && $@ =~ /Table.*?exist/ ) {
        $log->out("CREATE TABLE logapi_users_$table_date_month");
        eval {
            create_table_by_schema(PPCLOG, "logapi_users_$table_date_month", like => "ppclog.logapi_users_YYYYMM", if_not_exists => 1);

            do_mass_insert_sql(PPCLOG, "insert into logapi_users_$table_date_month (operator_uid, client_uid, date, cnt)
                                        values %s 
                                        ", $insert);
        };
    } elsif( $@ ) {
        $log->out(Dumper ['$@',$@]);
    }

    $log->out("stop processing $table_name");

}

$log->out("end copying data");