#!/usr/bin/perl

=head1 DEPLOY

approved by zhur

ppcdict:

CREATE TABLE IF NOT EXISTS `api_queue_stat` (
  `id` int(11) NOT NULL auto_increment,
  `uid` int(11) NOT NULL default '0',
  `options` text NOT NULL,
  `status` enum('Ready','Process','Done','Deleted') NOT NULL default 'Ready',
  `timecreate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `timeprocess` timestamp NOT NULL default '0000-00-00 00:00:00',
  `rank` tinyint(4) default '0',
  `proc_id` varchar(32) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `status` (`status`),
  KEY `i_timecreate` (`timecreate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `api_queue_forecast` (
  `id` int(11) NOT NULL auto_increment,
  `uid` int(11) NOT NULL default '0',
  `options` text NOT NULL,
  `status` enum('Process','Done','Deleted') NOT NULL default 'Process',
  `timecreate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `timeprocess` timestamp NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  KEY `status` (`status`),
  KEY `i_timecreate` (`timecreate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `api_queue_wordstat` (
  `id` int(11) NOT NULL auto_increment,
  `uid` int(11) NOT NULL default '0',
  `options` text NOT NULL,
  `status` enum('Process','Done','Deleted') NOT NULL default 'Process',
  `timecreate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `timeprocess` timestamp NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  KEY `status` (`status`),
  KEY `i_timecreate` (`timecreate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


    Скрипт выполнять на сервере, где установлен пакет yandex-direct-soap-scripts (сейчас это ppcsoap02d).

    Последовательность действий:
      ДО выкладки пакета:
        1. изменения в базе (до выкладки пакета)

      ПОСЛЕ выкладки пакета:

        2. запускаем локальный nginx сервер (на всех ppcsoap*):
            sudo /etc/init.d/files-server-api start

        3. останавливаем часть контроллеров API - 
                спец.файликом на всех ppcsoap*: 
echo "api_CreateNewReport,api_GetReportList,api_DeleteReport,api_CreateNewForecast,api_GetForecast,api_DeleteForecastReport,api_GetForecastList,api_CreateNewWordstatReport,api_GetWordstatReport,api_GetWordstatReportList,api_DeleteWordstatReport" > /var/www/ppc.yandex.ru/protected/run/cmd_stop.flag

        4. выполняем в БД ppcdict запросы (выполняться должны менее 10 секунд каждый):

insert into api_queue_stat select id, uid, options, status, timecreate, timeprocess, rank, proc_id from api_reports_new;

insert into api_queue_forecast select forecast_id as id, uid, options, IF(status='Pending', 'Process', status) as status, timecreate, timeprocess from api_forecast_new;

insert into api_queue_wordstat select wordstat_id as id, uid, options, IF(status='Pending', 'Process', status) as status, timecreate, timeprocess from api_wordstat_new;

        5. запускаем этот deploy-скрипт (может работать 10-30 минут, во время выполнения нужно следить за работоспособностью гластера!)

        6. разблокируем закрытые контроллеры апи - 
                удаляем на всех ppcsoap: 
                rm /var/www/ppc.yandex.ru/protected/run/cmd_stop.flag

        7. если все ок (проверяют - mirage@, или zhur@) - то позже (через 30-60-... минут) можно удалить текущие файлы с отчетами:
            # rm /opt/ppc-data/soap-files/stat_*
            # rm /opt/ppc-data/soap-files/wordstat/wordstat_*
            # rm /opt/ppc-data/soap-files/forecast/forecast_*

=cut

use File::Slurp qw/read_dir/;
use File::Copy qw/copy/;
use File::Touch qw/touch/;

# stop daemons
touch("/var/www/ppc.yandex.ru/protected/run/apiReportDaemon.stop");
touch("/var/www/ppc.yandex.ru/protected/run/apiForecastDaemon.stop");
touch("/var/www/ppc.yandex.ru/protected/run/apiWordstatDaemon.stop");

# ждем остановки демонов - 60 секунд (обычно должно быть достаточно)
warn "Sleep 60 sec...";
sleep(60);

my $BASE_DIR = "/opt/ppc-data/soap-files";
# my $BASE_DIR = "/var/www/beta.mirage.8032/soap-files/";

warn "Start file copy";

# stat reports
my @files = read_dir($BASE_DIR);
mkdir "$BASE_DIR/reports";
foreach my $fn (@files) {
    next unless $fn && $fn =~ /^stat\_/;

    my ($subdir_name) = $fn =~ /^stat\_(.{2})/;

    if ($subdir_name) {
        my $NEW_DIR_NAME = "$BASE_DIR/reports/$subdir_name";
        mkdir $NEW_DIR_NAME;

        copy("$BASE_DIR/$fn", "$NEW_DIR_NAME/$fn") or die "Can't copy file: $BASE_DIR/$fn to $NEW_DIR_NAME/$fn :".$!;
    }
}

warn "End process stat, start forecast";

# forecast reports
my @files2 = read_dir("$BASE_DIR/forecast");
foreach my $fn (@files2) {
    next unless $fn && $fn =~ /^forecast\_/;

    my ($subdir_name) = $fn =~ /^forecast_(.{2})/;

    if ($subdir_name) {
        my $NEW_DIR_NAME = "$BASE_DIR/forecast/$subdir_name";
        mkdir $NEW_DIR_NAME;

        copy("$BASE_DIR/forecast/$fn", "$NEW_DIR_NAME/$fn") or die "Can't copy file: $BASE_DIR/forecast/$fn to $NEW_DIR_NAME/$fn :".$!;
    }
}

warn "End process forecast, start wordstat";

# wordstat reports
my @files3 = read_dir("$BASE_DIR/wordstat");
foreach my $fn (@files3) {
    next unless $fn && $fn =~ /^wordstat\_/;

    my ($subdir_name) = $fn =~ /^wordstat\_(.{2})/;

    if ($subdir_name) {
        my $NEW_DIR_NAME = "$BASE_DIR/wordstat/$subdir_name";
        mkdir $NEW_DIR_NAME;

        copy("$BASE_DIR/wordstat/$fn", "$NEW_DIR_NAME/$fn") or die "Can't copy file: $BASE_DIR/wordstat/$fn to $NEW_DIR_NAME/$fn :".$!;
    }
}

warn "The end.";