#!/usr/bin/perl -w

# approved by lena-san
# добавляет в таблицу логов по пользователем новое поле - версия API
# выполнять на сервере ppc
# когда нужно выполнить: до выкладки
# примерное время выполнения: около 30 секунд

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Time::HiRes qw/time sleep/;
use ScriptHelper;

use Settings;
use DBTools;

$log->out("start modifiynd logapi_users");

for my $table (reverse sort @{get_one_column_sql(PPCLOG, "show tables like 'logapi_users%'")}) {
    $log->out($table);
    next if grep {$_->{Field} eq 'api_version'} @{get_all_sql(PPCLOG, "DESC $table")};
    $log->out("start alter");
    my $t = time();
    do_sql(PPCLOG, "alter table $table add column `api_version` tinyint(4) default '1', 
                                       drop PRIMARY KEY,
                                       add PRIMARY KEY  (`date`,`client_uid`,`operator_uid`,`api_version`), 
                                       add KEY (`operator_uid`,`api_version`)");
    my $sleep = time() - $t;
    $log->out("start sleep $sleep");
    sleep($sleep);
}

$log->out("stop modifiynd logapi_users");