#!/usr/bin/perl -w

# approved by lena-san
# добавляет в таблицу логов по пользователем новое поле - версия API
# (для архивных таблиц, в неархивных альтер уже выполнен)
# выполнять на сервере ppc
# когда нужно выполнить: до или после выкладки
# примерное время выполнения: около 10 секунд

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Time::HiRes qw/time sleep/;
use ScriptHelper;

use Settings;
use DBTools;

$log->out("start modifiyng logapi_users");

for my $table (reverse sort @{get_one_column_sql(PPCLOG, "show tables like 'logapi_users%'")}) {
    $log->out($table);
    next if grep {$_->{Field} eq 'api_version'} @{get_all_sql(PPCLOG, "DESC $table")};
    $log->out("start alter");
    my $t = time();
    do_sql(PPCLOG, "alter table $table add column `api_version` tinyint(4) default '1'");
    my $sleep = time() - $t;
    $log->out("start sleep $sleep");
    sleep($sleep);
}

$log->out("stop modifiyng logapi_users");