#!/usr/bin/perl -w

# approved by lena-san
# дает субклиентам агенств, которые пользовались api с 1 января 2011 года право api_enable = Yes (использовать api)
# выполнять на сервере ppc
# когда нужно выполнить: до или после выкладки
# примерное время выполнения: около 10 секунд

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Time::HiRes qw/time sleep/;
use List::MoreUtils qw/uniq/;
use ScriptHelper;

use Settings;
use DBTools;
use RBACDirect;
use RBAC2::Extended;
use Primitives;


$log->out('start granting rights');
$log->out("Searching subclients who use api");

my @uids = ();

for my $table (reverse sort @{get_one_column_sql(PPCLOG, "show tables like 'logapi_users_2011%'")}) {
    push @uids, @{get_one_column_sql(PPCLOG, "select distinct operator_uid from $table")};
}

@uids = uniq @uids;

my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
die "Can't connect to RBAC" if ! defined $rbac || ! $rbac->InitReq(1);

my @agency_clients = ();
my @easy_clients = ();

foreach my $uid (@uids) {
    if (rbac_has_agency($rbac, $uid)) {
        push @agency_clients, $uid;
    }

    if (is_easy_user($uid)) {
        push @easy_clients, $uid;
    }
}

$log->out("Number of subclients who use api: ".scalar @agency_clients);
$log->out(@agency_clients);
$log->out("Number of easy users who use api: ".scalar @easy_clients);
$log->out(@easy_clients);

my @all_clients_to_grant = (@agency_clients, @easy_clients);
$log->out("Number of all clients to grant access: ".scalar @all_clients_to_grant);

my $lines_set_default = do_sql(PPC, ["update users_api_options set api_enabled = ?", where => {uid__not_in => \@all_clients_to_grant, api_enabled => 'Yes'}], 'Default');
$log->out("Default access is set to clients: ".$lines_set_default);

$log->out("Granting rights");

my $lines = do_sql(PPC, ["update users_api_options set api_enabled = ?", where => {uid => \@all_clients_to_grant, api_enabled => 'Default'}], 'Yes');
$log->out("OK: ".$lines);
$log->out("subclients and easy users with api_enabled = Yes: ".get_one_field_sql(PPC, ["select count(uid) from users_api_options", where => {uid => \@all_clients_to_grant, api_enabled => 'Yes'}]));
$log->out('stop granting rights');
