# approved by zhur
# .migr
[
    {
        type => 'sql',
	db => 'ppc',
	when => 'any',
	webstop => 1,
	comment => qq/добавить поле для автобюджета, по какой цели оптимизировать
добавить поле для будущей стратегии "показ только в блоке справа"
/,
        time_estimate => '3 мин',
	sql => q/
alter table campaigns
  add autobudget_goal_id int default NULL after autobudget_avg_bid
  , add strategy_no_premium enum('highest_place', 'min_price') default NULL after strategy_min_price;
	/,
    },
    {
        type => 'sql',
	db => 'ppc',
	when => 'before', 
	comment => 'добавить таблицу с целями по кампаниям
добавить таблицу с количеством доменов на кампаниях',
        time_estimate => '2 сек.',
	sql => [q/
create table camp_metrika_goals (
    cid int unsigned NOT NULL,
    goal_id int NOT NULL,
    goals_count int NOT NULL default 0,
    stat_date timestamp NOT NULL,

    PRIMARY KEY (cid, goal_id),
    KEY (stat_date)
);
	/,
       q/
create table camp_domains_count (
    cid int unsigned NOT NULL,
    domains_count int unsigned NOT NULL default 0,

    PRIMARY KEY (cid)
);
/,
],
    },
]

# на devtest
# Query OK, 3046751 rows affected (2 min 21.36 sec)
# Records: 3046751  Duplicates: 0  Warnings: 0
