#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script', 
	when => 'after',
	comment => "примерное время выполнения: около 2 минут\nвыставляем правильный phoneflag объявлениям без визитки",
    }


=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use ScriptHelper;
use Settings;
use DBTools;

$log->out('searching for banners to change');

my $banners = get_one_column_sql(PPC_HEAVY, "select bid from banners where vcard_id is Null and phoneflag != 'New'");

$log->out('number of banners to change: '. scalar @{$banners || []});
$log->out('start repairing');

my $cnt = 0;
while( my @chunk = splice @$banners, 0, 500 ) {
    my $rows_changed = do_sql(PPC, ["update banners set phoneflag='New', LastChange = LastChange", where => {bid => \@chunk, phoneflag__ne => 'New', vcard_id__is_null => 1}]);
    $rows_changed = $rows_changed+0;
    $log->out("$rows_changed banners repaired, ".scalar @$banners." banners rest");
    $cnt += $rows_changed;
}

$log->out("number of rows changed: $cnt");
$log->out('stop repairing');
