#!/usr/bin/env migrator.pl
# approved by zhur
# .migr
[
  {
    type => 'sql',
    db => 'ppcdict',
    time_estimate => '1 сек',
    sql => q|
        CREATE TABLE `metrika_goals` (
          `goal_id` int(10) unsigned NOT NULL,
          `name` varchar(255) default NULL,
          `counter_status` enum('Active','Deleted') NOT NULL default 'Active',
          `goal_status` enum('Active','Deleted') NOT NULL default 'Active',
          `goal_type` enum('url','number') NOT NULL default 'url',
          PRIMARY KEY  (`goal_id`)
        ) DEFAULT CHARSET=utf8;
    |,
    when => 'before',
    comment => 'добавить таблицу с целями из метрики'
  },
  {
    type => 'manual',
    text => "копирование данных из ppcstat в ppcdict
 на сервере ppc от пользователя ppc выполнить: 
/var/www/ppc.yandex.ru/bin/mysql_direct.pl --dump ppcstat:1 conv_goals | grep '^INSERT INTO' | sed 's/`conv_goals`/`metrika_goals` (goal_id, name, goal_status, goal_type)/' | /var/www/ppc.yandex.ru/bin/mysql_direct.pl ppcdict",
    when => 'before',
    time_estimate => '10 sec',
  }
]
