#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        comment => "исправляет логины-двойники в Директе",
        time_estimate => '10 секунд'
    }


=cut

=pod description

    В базе Директа есть пользователи, имеющие своих двойников (логины удаленные в Паспорте в 2006 появились позже снова)
    
    Скрипт ссправляет логины удаленных в Паспорте пользователей на "corrupted-[% login %]"
    У всех пользователей уже в description='deleted_in_passport'

=cut

use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use ScriptHelper;

use Settings;
use DBTools;
use Primitives;

$log->out("start");

# находим логины-двойники
my $logins = get_one_column_sql(PPC, "select login from users group by login having count(*) > 1");
my $uids = get_one_column_sql(PPC, ["select uid from users", where => { login => [grep {$_} @$logins] }]);

# пользователей должно быть 233 (466 - так как логина по два)
$log->die("Count users more than 466") if scalar @$uids > 466;

# проверяем, что в Паспорте их действительно нет
my $hash = {};
foreach my $uid (@$uids) {
    $hash->{$uid} = get_login_by_uid_passport($uid);
}

my @deleted_users = grep { ! $hash->{$_} } keys %$hash;
$log->out(\@deleted_users);

foreach my $uid (@deleted_users) {
    $log->out("processed $uid");
    do_sql(PPC, "update users set login=concat('corrupted-',login) where uid = ?", $uid);
}

$log->out("finish");
