#!/usr/bin/perl -w

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script', 
        when => 'after',
        time_estimate => '4 min',
        comment => "добавляем пропущенные ранее вследствие ошибки данные в таблицу логов logapi_users_201104 за 12-19 апреля",
    }


=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use ScriptHelper;
use Settings;
use DBTools;

$log->out('start repairing');

$log->out('searching for uids to add');

my $mdata_uids;

my $table_name = 'logapi_users_201104';

for my $suffix (12..19) {
    my $tabledate = "201104$suffix";
    $log->out("retrieving data from table logapi_$tabledate");
    my $lines = get_all_sql(PPCLOG, "select uid, api_version, count(uid) as cnt from logapi_$tabledate where cluid = ? group by uid, api_version", '');
    foreach my $line (@$lines) {
        push @$mdata_uids, [$line->{uid}, 0, $tabledate, $line->{cnt}, $line->{api_version}];
    }
}

$log->out('rows to add: '.scalar @$mdata_uids);

# делаем запись в таблицу логов по пользователям
my $sql = "insert ignore into $table_name (operator_uid, client_uid, date, cnt, api_version) values %s";
my $lines = do_mass_insert_sql(PPCLOG, $sql, $mdata_uids);

$log->out("rows added: $lines");

$log->out('stop repairing');
