#!/usr/bin/perl -w

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        comment => "заменяет в логинах точки на дефисы",
        time_estimate => '4 секунды'
    }


=cut

=pod description

    Пользователи, созданные через dostup-api попали в таблицу users с точками в логине.
    Скрипт исправляет такие логины, заменяя точки на дефис

=cut

use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use ScriptHelper;

use Settings;
use DBTools;
use Primitives;

$log->out("start");

my $users = get_all_sql(PPC, "select uid, login from users where login like '%.%' and login not like '%@%'");
$log->out($users);

do_sql(PPC, ["update users set login = replace(login,'.','-')", where => { uid => [map {$_->{uid}} @$users]} ]);

$log->out("finish");
