#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        comment => "исправляет неправильное написание флага unfamily в Директе (для семейного пользователя)",
        time_estimate => '5 минут'
    }

=cut

# DIRECT-12653 : исправление названий флагов у объявлений adult => unfamily

use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use DBTools;
use Yandex::Log;

warn "START";

my $log = new Yandex::Log(log_file_name => "fix_adult_banner_flags.log");

my $cnt = 0;
my $cache = {};

my $res = get_all_sql(PPC_HEAVY, "select bid, flags from banners where flags like '%adult%' order by bid");

warn "START PROCESS";

foreach my $r (@$res) {

    $r->{flags} =~ s/adult/unfamily/g;

    push @{ $cache->{ $r->{flags} } }, $r->{bid};
}

foreach my $flags (keys %$cache) {
    
    while (my @bids = splice @{ $cache->{$flags} }, 0, 1000) {

        $log->out({flags => $flags, bids => \@bids});

        # обновляем флаги и переотправляем в БК
        do_update_table(PPC, 'banners', { flags => $flags, statusBsSynced => "No" }, where => { bid => \@bids });

        sleep(5);
    }

    sleep(10);
}

warn "END.";
