#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '2 sec',
        comment => 'чистим список недоступных доменов от невалидных доменов',
    }

=cut

use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use ScriptHelper;
use Settings;
use DBTools;

use Yandex::Validate qw/is_valid_ip/;
use Yandex::IDN qw/is_valid_domain/;

my $domains = get_one_column_sql(PPC, 'SELECT domain FROM metrica_dead_domains WHERE uid = 0');
if ($domains && @$domains) {
    my @bad_domains = grep { !( $_ && (is_valid_domain($_) || is_valid_ip($_)) ) } @$domains;
    if (@bad_domains) {
        print 'Deleting domains: ' . join(',', @bad_domains)."...\n";
        do_delete_from_table(PPC, 'metrica_dead_domains', where => {uid => 0, domain => \@bad_domains});
        print "DONE\n";
    }
}
