#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '2 сек',
        comment => 'восстанавливаем права в RBAC на кампании клиентов удалённых менеджеров',
    }

=cut

use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use DBTools;

use RBAC2::Extended;
use RBACDirect;
use Primitives;

my @cids = qw/
1830373
917830
1003563
2172966
306668
2724138
2088049
790872
385864
1276671
235576
73309
728920
1891023
1432221
2848893
1823233
1475353
829730
2663162
686846
1556536
2827796
786596
672925
2030508
1974968
1439301
318626
809666
480433
1837540
262407
923228
1009501
1999522
1009500
838879
433391
996518
2457744
1303042
43801
3476622
1320578
1303039
319529
1030861
860597
216663
824666
3556886
3522272
812317
766538
46825
882813
1529203
3475932
1629278
73853
568454
135234
2662908
1953565
1983605
1491729
721621
269336
762972
1318144
794747
269275
750808
1303038
2554954
220690
539112
1096818
1009508
787629
2158810
2031504
1407439
5509
684344
702200
1668386
1646916
806336
1731207
861673
1303041
1731206
1289259
1303130
931493
1391051
3381023
271675
1067138
1832154
1499202
2017810
362976
783986
/;

my $manager_login = 'yndx-malahova';
my $manager_uid = get_uid_by_login2(PPC, $manager_login);

my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
die 'cannot get RBAC' unless ($rbac && ref($rbac) eq 'RBAC2::Extended');
my $rbac_init_res = $rbac->InitReq( 1 );
die "error in RBAC's InitReq: $rbac_init_res" unless defined $rbac_init_res && $rbac_init_res == 1;

my @fixed_camps;
@fixed_camps = @cids;
my $camps = get_all_sql(PPC, ['SELECT cid, ClientID, uid, AgencyUID, ManagerUID, type FROM campaigns', WHERE => {cid => \@cids, statusEmpty => 'No'}]);
for my $camp(@$camps) {
    my $cid = $camp->{cid};

    # проверим, что кампания ещё не починена
    if ( rbac_is_scampaign($rbac, $cid) || rbac_is_agencycampaign($rbac, $cid) ) {
        print "Skipping $camp->{cid} because it look like not broken\n";
        next;
    }

    if ($camp->{AgencyUID} || $camp->{ManagerUID}) {
        print "Skipping $cid because of AgencyUID = $camp->{AgencyUID} or ManagerUID = $camp->{ManagerUID}\n";
        next;
    }

    if ($camp->{type} ne 'text') {
        print "Skipping $cid because of type = $camp->{type}\n";
        next;
    }

    print "Fixing campaign $cid...\n";

    my $rbac_error = rbac_save_camp_for_manager($rbac, $manager_uid, $camp->{uid}, $cid, type => $camp->{type});
    die "RBAC::rbac_save_camp_for_manager error: $rbac_error" if $rbac_error;

    push @fixed_camps, $cid;
}

do_update_table(PPC, 'campaigns', {ManagerUID => $manager_uid, statusBsSynced => 'No'}, where => {cid => \@fixed_camps});

print "DONE\n";
