#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '5 min',
        comment => 'заменяем часть пользователей gtx-* на реальные логины клиентов геоконтекста, для этого создаем представителей/объединяем ClientID, передаем кампании главным представителям'
    }

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use Settings;
use ScriptHelper;
use Primitives;
use PrimitivesIds;
use RBACDirect;
use RBAC2::Extended;
use Yandex::Balance;
use DBTools;
use Common;
use User;

$log->out('start');

my $UID = 112635943;
my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
warn "Can't connect to RBAC" if ! defined $rbac || ! $rbac->InitReq(1);


# один проблемный клиент -- неконсистентность данных в рбаке
# uid = 98072092, ClientID = 1087049
rbac_create_client($rbac, 98072092)
        && $log->warn("rbac_create_client($rbac, 98072092)");

while (my $line = <DATA>) {
    chomp $line;
    next if substr($line, 0, 1) eq '#';
    my ($gtx_uid, $gtx_client_id, $real_uid) = split ' ', $line;

    my $role = rbac_who_is($rbac, $real_uid);
    if ($role eq 'agency') {
        $log->warn("$real_uid is an agency");
        next;
    }

    my $real_client_id;
    if ($real_client_id = get_clientid(uid => $real_uid)) {
        $log->out("1 $line $real_client_id");
        # есть в директе
        balance_merge_clients($UID, $real_client_id, $gtx_client_id)
                && $log->warn("balance_merge_clients($UID, $real_client_id, $gtx_client_id)");

        rbac_merge_clients($rbac, $real_client_id, $gtx_client_id)
                && $log->warn("rbac_merge_clients($rbac, $real_client_id, $gtx_client_id)");
    } elsif ($real_client_id = get_clientid_by_uid($real_uid)) {
        $log->out("2 $line $real_client_id");
        # нет в директе, есть в балансе
        my $info = get_info_by_uid_passport($real_uid);
        create_update_user($real_uid, {ClientID => $real_client_id, %$info});

        rbac_create_client($rbac, $real_uid)
                && $log->warn("rbac_create_client($rbac, $real_uid)");

        balance_merge_clients($UID, $real_client_id, $gtx_client_id)
                && $log->warn("balance_merge_clients($UID, $real_client_id, $gtx_client_id)");

        rbac_merge_clients($rbac, $real_client_id, $gtx_client_id)
                && $log->warn("rbac_merge_clients($rbac, $real_client_id, $gtx_client_id)");
    } else {
        $log->out("3 $line $real_client_id");
        # нигде нет
        $real_client_id = $gtx_client_id;
        my $info = get_info_by_uid_passport($real_uid);
        create_update_user($real_uid, {ClientID => $real_client_id, %$info});

        rbac_create_client_main_rep($rbac, $real_client_id, $real_uid)
                && $log->warn("rbac_create_client_main_rep($rbac, $real_client_id, $real_uid)");

        create_client_id_association($real_uid, $real_client_id, $UID)
                || $log->warn("create_client_id_association($real_uid, $real_client_id, $UID)");

        rbac_switch_client_chief($rbac, $real_uid)
                && $log->warn("rbac_switch_client_chief($rbac, $real_uid)");
    }

    rbac_drop_client_rep($rbac, $real_client_id, $gtx_uid)
            && $log->warn("rbac_drop_client_rep($rbac, $real_client_id, $gtx_uid)");

    remove_client_id_association($UID, $gtx_uid, $real_client_id)
            || $log->warn("remove_client_id_association($UID, $gtx_uid, $real_client_id)");

    do_sql(PPC, 'DELETE FROM users WHERE uid = ?', $gtx_uid);
    Common::change_uid($gtx_uid, $real_uid);
}
$log->out('finish');

__DATA__
113802189 1493290 9462865
113885834 1494194 76133448
113892685 1494225 6962664
113892886 1494232 85886
113895484 1494297 2307237
113907110 1494352 109321524
113921450 1494399 80963597
113956721 1494612 23859991
114048544 1495436 24548153
114050866 1495471 54632
114053235 1495526 92384028
114058735 1495623 80546611
114097535 1496080 2244433
114385598 1498046 7016948
114386311 1498043 92384028
114387771 1498087 24645608
114388815 1498093 98072092
114393120 1498182 2976750
114403737 1498359 24421215
114404805 1498374 24421215
114409543 1498458 98887498
114411758 1498490 98887498
114414311 1498534 92917755
114475653 1498833 38939074
114482548 1498853 38939074
114620980 1499553 110289292
114621799 1499560 88984472
114623797 1499613 44316675
114627419 1499662 77504913
114636920 1499824 79647
114663899 1500234 93112615
114665724 1500293 19601197
114669497 1500311 26424821
114783229 1501092 73002663
114866639 1501576 49235089
114973670 1502376 60624251
114974889 1502382 109176322
114977421 1502416 60624251
114979094 1502468 112583780
115004046 1502611 20890966
115152286 1503802 44054989
115158939 1503883 35634263
115518516 1506587 31156056
115521999 1506624 83644998
115526008 1506703 43286640
115532101 1506781 115180260
115548920 1507044 114996112
115833613 1508431 75422756
115838370 1508488 68701593
115932050 1509612 11855397
115936441 1509665 43963920
115938639 1509694 41241158
115946042 1509822 79998653
116107497 1511021 115843991
116108131 1511025 106984000
116148186 1511209 87865768
116179765 1511325 98887498
116199111 1511604 14447984
116208492 1511754 87772248
116308136 1512739 25016221
116331445 1513086 95892475
116335896 1513110 20561997
116336404 1513138 20561997
116597058 1515409 13608136
116597584 1515431 116484748
116603240 1515534 12519662
116622701 1515796 95892475
116722268 1517171 36199266
116726882 1517233 96154923
116787197 1517862 49213381
116824224 1518402 18491710
116895047 1519309 30962374
116920066 1519742 113851247
116920474 1519750 116888844
116925359 1519841 110090446
116932009 1519975 24859586
117027991 1521144 84334413
117359592 1523859 35670146
117456529 1524950 113851247
117461218 1525047 13234125
117472088 1525236 29473725
117666125 1527022 105648004
117688862 1527529 109276212
117697097 1527649 61591395
117806823 1529002 50523618
117815783 1529141 112583780
118123382 1531989 8154933
118141596 1532285 110914454
118144330 1532348 18164845
118148450 1532427 112639301
118209471 1533311 115092005
118221647 1533548 79745142
118227250 1533650 16663540
118230478 1533688 116377411
118237976 1533851 8181548
118238536 1533849 102584172
118305352 1534637 114888608
118352157 1535428 34857620
118420387 1536213 103728625
118421087 1536228 62605222
118423575 1536277 78557408
118425208 1536299 40508853
118426307 1536308 42160415
118427033 1536327 49235089
118447810 1536697 44152209
118519493 1537541 73084511
118542082 1537943 116282428
118545902 1538042 38337668
118547405 1538060 86890266
118596944 1538642 16737206
118608504 1538827 90289893
118612613 1538898 79249197
118616601 1538980 73070533
118624705 1539060 65972042
118889028 1541490 84457884
118889695 1541502 7016948
118890348 1541524 23501807
118891234 1541538 66045746
118891700 1541563 30859557
118894868 1541637 33238015
118895513 1541630 13273224
118907099 1541937 591410
118921211 1542248 97698235
118922238 1542267 7188475
118994632 1543657 1371537
118995702 1543691 55164822
119006763 1543929 396379
119067592 1544970 26638800
119069894 1545044 83183090
119074010 1545156 73070533
119081646 1545343 92824832
119082061 1545350 1604218
119085671 1545411 52042955
119086523 1545431 113991399
119087581 1545438 18271522
119088146 1545449 86611436
119092157 1545576 14516594
119101728 1545735 13707047
119102186 1545754 13707047
119102772 1545747 4635353
119319412 1548279 112460947
119320988 1548312 109200244
119322904 1548363 5218471
119325693 1548439 27958666
119328929 1548505 109534539
119329834 1548555 118959563
119331359 1548585 37590928
119336167 1548701 43277084
119343058 1548892 117800390
119350994 1549029 110314277
119354446 1549086 9544522
119414659 1550175 41855545
119419209 1550278 113626197
119429316 1550488 67403441
119435660 1550636 11623012
119436478 1550672 17304868
119493231 1551464 10204422
119500214 1551626 118974045
119589111 1553054 28749715
119613100 1553501 52795482
119716508 1554971 13057080
119939718 1557079 116772270
119952742 1557368 119842098
119953553 1557404 35215450
119966421 1557680 79310865
119966815 1557693 12894728
119974795 1557837 44316675
120029640 1558543 39213799
120031651 1558587 60109896
120036893 1558715 39785467
120037647 1558719 3029802
120050504 1559031 20742515
120139472 1560376 50300218
120220090 1561530 119857318
120221475 1561566 45242936
120221920 1561587 31669666
120237769 1561856 114785077
120254127 1562187 115861145
120336623 1563397 46336421
120349675 1563588 30714249
120730337 1567402 32254934
120743117 1567679 4860654
120768773 1568145 96224387
120777017 1568249 95181875
120778244 1568291 53196506
120848984 1569212 21258636
120849925 1569209 363679
120850646 1569226 101881797
120851611 1569247 96882520
120851641 1569248 96882520
120857128 1569342 119994960
120857464 1569330 67525043
120858495 1569361 20394292
120865994 1569535 13483984
120946850 1570717 55641951
120949216 1570757 70215546
121019202 1571753 105245940
121023033 1571831 120347806
121025022 1571860 26025083
121030073 1571964 18898379
121031637 1572001 108895397
121032641 1572031 97071209
121035132 1572061 80158083
121275440 1574691 75557781
121291438 1575022 68794982
121307913 1575285 21063802
121307920 1575286 21063802
121362054 1576107 87462352
121377660 1576503 121037857
121378376 1576515 109934175
121382482 1576604 55641951
121382778 1576624 55641951
121387024 1576736 79102385
121450021 1577731 92763985
121462749 1578013 4686715
121478989 1578283 35338360
121535165 1579147 72704971
121574542 1579972 119444149
121575127 1579962 119444149
121575459 1579968 119444149
121627292 1580683 13744034
121637657 1580864 95303318
121637666 1580880 95303318
121648793 1581093 16489030
121651823 1581139 40453430
121653959 1581179 115460942
121656213 1581223 41371999
121922499 1584254 71578547
121923779 1584262 37405155
121974466 1584941 111234492
121975927 1584969 30313311
121985942 1585187 60624251
121990907 1585287 121551729
122000225 1585524 27656757
122005077 1585605 121705138
122005081 1585626 121705138
122005906 1585651 56392740
122006289 1585642 102721525
122006293 1585656 102721525
122006302 1585643 102721525
122006307 1585644 102721525
122006309 1585658 102721525
122006315 1585659 102721525
122014918 1585817 102607432
122019167 1585912 102605443
122086735 1586887 20951180
122087976 1586921 109267144
122088544 1586942 121863688
122091135 1586994 45832649
122097085 1587118 113736137
122253129 1589446 21437533
122257406 1589533 121979687
122259394 1589563 65384617
122261229 1589618 4607796
122262913 1589644 27040423
122264842 1589696 10511624
122283478 1590014 74810151
122504603 1592465 31442681
122505180 1592447 25420
122508518 1592561 120444007
122509215 1592548 500180
122527108 1592981 93953695
122584637 1593748 20742515
122589062 1593887 53218484
122665642 1595135 121968237
122665666 1595136 121968237
122668125 1595214 4526523
122671089 1595270 16403601
122676166 1595426 100103251
122687159 1595693 38623179
122748365 1596677 15156407
122748372 1596694 15156407
122752244 1596779 27280089
122754262 1596831 91307903
122758661 1596951 84584474
122763841 1597030 28159270
122771432 1597216 15304403
122778877 1597321 27516919
123050375 1600312 56045556
123051392 1600352 90697851
123079821 1600954 47826888
123127970 1601644 123052103
123156548 1602304 12080562
123197006 1602902 102607432
123197576 1602906 31432088
123198354 1602951 98508810
123201128 1603011 119677273
123202613 1603028 32897250
123213841 1603348 103541804
123218600 1603447 38780872
123223641 1603562 27726948
123289136 1604724 10511624
123596295 1608454 32810316
123604845 1608660 21597718
123605756 1608675 83380879
123605759 1608692 83380879
123605815 1608677 83380879
123605822 1608693 83380879
123605839 1608678 83380879
123605859 1608679 83380879
123620333 1608941 16644783
123626644 1609027 11526520
123670486 1609702 92384028
123703658 1610434 63191988
123752979 1611194 110271960
123754974 1611238 116180957
123759349 1611328 37094871
123760612 1611394 39631446
123763108 1611430 87706459
123769699 1611561 83380879
123769713 1611562 83380879
123769723 1611564 83380879
123769727 1611548 83380879
123769738 1611565 83380879
123769747 1611566 83380879
123775797 1611691 123385849
123778290 1611735 115514358
123824624 1612355 34455955
123826886 1612389 121645543
123828335 1612440 119677273
123828341 1612419 119677273
123833747 1612542 64602347
123834166 1612558 73575263
123836876 1612601 35818775
123842972 1612711 22498837
123843245 1612715 123074528
123847795 1612802 73098312
123849028 1612831 25583802
123850715 1612830 79701029
124075224 1614977 101878805
124088956 1615304 45451762
124092003 1615363 79059039
124104026 1615622 40859429
124150454 1616262 118974302
124166687 1616677 124073221
124168602 1616733 98962928
124176418 1616901 14917463
124176883 1616909 2777929
124183957 1617022 115939832
124183960 1617040 115939832
124242021 1618009 119678188
124242318 1618014 10599580
124254510 1618190 35674989
124312373 1619232 47272240
124313410 1619253 13833852
124315256 1619293 123513974
124317382 1619333 118444119
124318365 1619373 26668882
124521084 1621932 24398782
124521089 1621933 24398782
124521097 1621934 24398782
124521098 1621935 24398782
124521257 1621937 24398782
124521260 1621926 24398782
124521267 1621927 24398782
124521269 1621938 24398782
124521274 1621939 24398782
124521293 1621928 24398782
124521295 1621940 24398782
124521299 1621929 24398782
124523693 1622012 101963105
124543120 1622467 13824475
124544342 1622497 41241158
124585233 1623075 59225465
124593166 1623252 51901281
124593779 1623264 95777267
124594072 1623279 88756881
124603911 1623499 100812293
124605195 1623516 77491988
124607184 1623547 92649392
124611907 1623672 74127691
124616037 1623773 85115102
124623017 1623991 90199558
124663174 1624486 102704600
124671497 1624806 47253498
124674980 1624932 66293279
124676784 1624964 14543491
124677161 1624992 98009507
124688139 1625246 62616614
124690908 1625324 12994020
124699430 1625508 100199495
124743659 1626207 25213351
124745364 1626229 48717863
124747424 1626300 116426086
124757455 1626591 102358224
124767228 1626818 123974820
124769771 1626868 100648357
124809105 1627429 44316675
124814415 1627551 114172190
124825513 1627904 108381182
124996601 1630108 95192569
125002629 1630297 25638254
125013967 1630562 123651658
125026165 1630809 7809730
125108070 1632411 32847550
125149328 1633084 26373892
125162206 1633359 43949244
125171492 1633574 7626701
125179359 1633729 49099503
125186917 1633802 21061985
125198010 1633960 64841201
125245148 1634898 25142330
125245875 1634925 951609
125295240 1635768 25469308
125298684 1635846 111706127
125298875 1635855 79294423
125316571 1636187 125219978
125319195 1636247 29494002
125322365 1636319 21619199
125323736 1636355 85412743
125494828 1638508 110587694
125495235 1638513 94439551
125498285 1638605 68633240
125498539 1638634 101051345
125505444 1638816 82761598
125507322 1638856 47377035
125507904 1638860 47377035
125508269 1638861 47377035
125509068 1638869 47377035
125571759 1639966 14927954
125573179 1639987 125450113
125575846 1640055 18817636
125586538 1640283 110206093
125588981 1640354 125503386
125591772 1640411 98887498
125646012 1641430 36177438
125652574 1641487 49137298
125656921 1641605 54494042
125669073 1641917 109290904
125722286 1642845 78928084
125722599 1642856 96240153
125727684 1642985 23169951
125729815 1643027 66387131
125730196 1643010 38566918
125734232 1643134 122147350
125735804 1643155 17424482
125741985 1643298 49167061
125743359 1643325 4502131
125782293 1643928 11000036
125800053 1644317 41636429
125801111 1644326 105965207
125804331 1644406 39815966
125804811 1644426 103367988
125804824 1644427 103367988
125809565 1644503 114369087
125809972 1644509 69576115
125971274 1646414 65433723
125971903 1646426 79015146
125991057 1646903 378963
125991390 1646923 83943691
126030065 1647479 4653859
126055821 1648120 118681857
126056583 1648147 123768213
126058946 1648182 123561202
126061366 1648262 9821848
126112363 1649087 17356864
126188710 1650423 9713608
126191717 1650519 62850140
126200042 1650675 6054582
126210617 1650995 84460345
126275949 1652244 14429674
126491403 1655342 92748778
126499701 1655569 109793532
126500174 1655579 126175927
126518333 1655968 12422166
126518347 1655969 12422166
126570454 1656963 37924310
126570556 1656956 609040
126572750 1657005 103174857
126579779 1657163 95142325
126581565 1657202 59791547
126586007 1657314 55259450
126628642 1658155 9711354
126638505 1658408 11436677
126638943 1658428 234538
126640320 1658454 51667834
126641087 1658484 98407816
126643334 1658533 94146716
126643784 1658536 75027811
126644187 1658561 49048005
126646634 1658610 98939711
126660032 1658921 33618141
126661325 1658937 44666220
126661604 1658940 69310196
126661785 1658964 59231979
126661807 1658965 59231979
126696060 1659560 18542479
126697295 1659599 30512624
126698230 1659610 74125596
126699436 1659642 7816896
126710780 1659913 102333052
126722761 1660135 105853089
126723004 1660139 92787640
126725753 1660224 27346449
126873895 1662130 52230785
126875539 1662186 72265304
126876078 1662193 64276908
126877278 1662229 35822531
126883849 1662409 78496284
126884635 1662420 56718577
126887263 1662492 121367593
126906277 1662983 25346284
126907059 1663007 73098312
126944385 1663674 18848145
126945749 1663731 125788324
126947652 1663772 105965207
126949982 1663838 119010861
126951601 1663887 124861720
126967455 1664274 69670312
126971778 1664373 22870471
126973388 1664407 13801316
126976368 1664468 11354106
127019773 1665286 19720028
127024906 1665440 97067524
127026562 1665460 76229365
127085387 1668364 6111784
127089036 1668418 4807221
127090325 1668441 126943352
127091144 1668474 39487545
127101578 1668782 38670202
127105834 1668883 14078733
127111123 1669053 101326347
127164968 1671014 108389767
127182503 1671390 31298179
127183633 1671411 49150974
127336945 1676342 105853089
127346839 1676586 28915360
127346929 1676553 127309043
127351290 1676661 27633992
127355593 1676778 20132109
127460016 1680713 102628068
127466903 1680891 42517796
127613409 1685454 29649681
127613414 1685470 17575275
127825804 1692748 20988732
127835572 1693004 87719032
127962117 1697469 95955182
128006729 1699308 36417820
128010514 1699406 25750716
128018490 1699603 69438888
128022758 1699702 107877774
128356468 1706535 49048005
