#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '2 сек',
        comment => 'восстанавливаем экранированные символы в названиях агентств',
    }

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use DBTools;
use ScriptHelper 'Yandex::Log' => [tee => 1];

use Common qw/add_to_balance_info_queue/;
use Primitives;
use Tools;
use Client;

$log->out('STARTED');

my $operator_uid = get_uid_by_login2(PPC, 'yndx.pankovpv.super');

my $clients = get_all_sql(PPC, 'SELECT ClientID, name FROM clients WHERE name LIKE "%&amp;%"');

for my $client(@$clients) {
    my $new_name = html2string(html2string( $client->{name} ));
    $log->out("ClientID $client->{ClientID}: $client->{name} ===> $new_name");

    create_update_client({client_data => {ClientID => $client->{ClientID}, name => $new_name}});

    # Переотправляем в Баланс всех представителей
    my $uids = get_one_column_sql(PPC, ['SELECT uid FROM users', WHERE => {ClientID => $client->{ClientID}}]) || [];
    add_to_balance_info_queue(PPC, $operator_uid, uid => $_) for @$uids;
}

$log->out('DONE');
