#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '40 минут на devtest',
    comment => 'включаем объявления, ошибочно невключенные мониторингом метрики. желательно выполнять во время спада нагрузки.',
}

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use List::MoreUtils qw/uniq/;

use Settings;
use DBTools;
use ScriptHelper;
use Common qw/reverse_domain/;
use Data::Dumper;

use Yandex::IDN qw/idn_to_ascii idn_to_unicode/;
use Yandex::MirrorsTools::Hostings qw/strip_www/;

use constant SETTLING_TIME => 10;

$log->warn('START');

# получем список действительно мёртвых доменов
$log->warn('Fetching dead domains data');
my $dead_data = get_all_sql(PPC, q#
        SELECT uid, domain
        FROM metrica_dead_domains
        WHERE start_time < NOW() - INTERVAL ? MINUTE
    #, SETTLING_TIME()
);

# группируем мёртвые домены по uid'у чтобы чуть-чуть сократить SQL-условие
my %dead_domains_by_uids;
for my $dead_rec(@$dead_data) {
    push @{ $dead_domains_by_uids{ $dead_rec->{uid} } }, normalize_domain($dead_rec->{domain});
}

# собираем SQL-условие вида (b.reverse_domain IN ('domain1.ru', 'www.domain1.ru', 'domain2.ru') AND c.uid => 123456) OR (b.reverse_domain IN ('domain3.ru', 'www.domain3.ru') AND c.uid => 7890123)
# по которому в дальнейшем будем выбирать баннеры
my @cond_groups;
while ( my($uid, $dead_domains) = each %dead_domains_by_uids ) {
    my @new_domains = uniq map { ($_, idn_to_unicode $_) } map { ($_, "www.$_") } @$dead_domains;
    my @revdomains = map {reverse_domain $_} @new_domains;
    push @cond_groups, 'OR' if @cond_groups;
    if ($uid > 0) {
        push @cond_groups, '(', { 'b.reverse_domain' => \@revdomains, 'c.uid' => $uid }, ')';
    } else {
        push @cond_groups, { 'b.reverse_domain' => \@revdomains };
    }
}

# выбираем баннеры (по PPC_HEAVY после синхронизации с мастером), у которых судя по данным metrica_dead_domains не должно быть statusMetricaStop
$log->warn('Fetching banners stopped by error');
my $sql_begin = q#
    SELECT b.bid, b.cid, b.uid, b.domain
    FROM banners b
    INNER JOIN campaigns c ON c.cid = b.cid
    INNER JOIN camp_options o ON c.cid = o.cid
    WHERE
        c.statusEmpty = 'No'
        AND o.statusMetricaControl = 'Yes' AND b.statusMetricaStop = 'Yes'
#;
wait_master([PPC, PPC_HEAVY]);
my $bugged_banners = get_all_sql(PPC_HEAVY, [$sql_begin, 'AND NOT (', @cond_groups, ')']);
$log->warn('Found ' . scalar(@$bugged_banners) . ' banners with wrong statusMetricaStop flag');

# собираем из выбранных баннеров список bid'ов, с которых надо снять statusMetricaStop, и cid'ов, которые надо добавить в очередь экспорта в БК metrica
my (@bids_to_update, %cids_to_sync);
{
local $Data::Dumper::Indent = 0;
for my $banner(@$bugged_banners) {
    $log->out(Dumper $banner);
    push @bids_to_update, $banner->{bid};
    $cids_to_sync{ $banner->{bid} } = undef;
}
}

while ( my @bids = splice(@bids_to_update, 0, 1000) ) {
    $log->warn('Updating one more banners bundle');
    # условие на statusMetricaStop нужно, чтобы лишний раз не поставить statusBsSynced на кампанию, с которой statusMetricaStop сняли между выборкой баннеров и снятьем флага
    do_update_table(PPC, 'banners', {statusMetricaStop => 'No', statusBsSynced => 'No'}, where => {bid => \@bids, statusMetricaStop => 'Yes'});
}

# добавляем затронутые кампании в очередь metrica на экспорт в БК
$log->warn('Adding ' . scalar(keys %cids_to_sync) . ' touched campaigns to BS export queue named metrica');
do_mass_insert_sql(PPC, 'INSERT INTO bs_export_specials (cid, par_type) VALUES %s ON DUPLICATE KEY UPDATE cid=cid',
    [ map {[$_, 'metrica']} keys %cids_to_sync ] );

$log->warn('DONE');


sub normalize_domain {
    my ($domain) = @_;

    return lc(idn_to_ascii(strip_www($domain)));
}
        
