#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '7 мин',
        comment => 'Убираем минусы из всех минус слов на кампанию',
    }

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use DBTools;
use ScriptHelper 'Yandex::Log' => [tee => 1];

use MinusWords;

$log->out('START');
my $rows_count = 10000;
my $offset = 0;
my $camps;

do {
    $camps = get_all_sql(PPC, "SELECT cid, minus_words FROM camp_options WHERE minus_words != '' LIMIT ?, ?", $offset, $rows_count);

    for my $camp (@$camps) {
        my $polished_words = polish_minus_words($camp->{minus_words});
        next if ($polished_words eq $camp->{minus_words});
        do_sql (PPC, "UPDATE camp_options SET minus_words=? WHERE cid=?", $polished_words, $camp->{cid} );
        $log->out(printf("updated cid: %s\n", $camp->{cid}, $polished_words));

        do_insert_into_table(PPC, 'bs_resync_queue', {cid=>$camp->{cid}});

    }
    $offset += $rows_count;

} while (scalar(@{$camps}) > 0);

$log->out('FINISH');
exit(0);