#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '2 секунды на devtest',
    comment => 'чистим очередь metrica от неверных номеров кампаний',
}

=cut

=head1 DESCRIPTION

    Миграция из DIRECT-12865 ошибочно помещала в очередь metrica номера баннеров, а не номера кампаний. 
    Когда кампании с такими номерами будут синхронизироватсья с БК, они ошибочно попадут в очередь metrica.
    Данная миграция чистит кампании, которые есть в bs_export_specials, но которых нет в очереди bs_export_queue.

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use List::MoreUtils qw/uniq/;

use Settings;
use DBTools;
use ScriptHelper;

$log->out('START');

$log->out('Fetching wrong cids');

my $all_cids = get_one_column_sql(PPC_HEAVY, 'SELECT cid FROM bs_export_specials es LEFT JOIN bs_export_queue eq USING(cid) WHERE es.par_type = "metrica" AND eq.cid IS NULL');

unless ($all_cids) {
    $log->warn('No wrong cids found');
    exit 0;
}

$log->out('Deleting ' . scalar(@$all_cids) . ' found cids');
while ( my @cids = splice(@$all_cids, 0, 1000) ) {
    $log->out('Deleting one more cids bundle: ' . join(',', @cids));
    # гоночная ситуация: после выборки может появиться запись в bs_export_queue с именно этой кампанией
    # но это не страшно: в худшем случае такая кампания попадёт в std очередь
    do_delete_from_table(PPC, 'bs_export_specials', where => {par_type => 'metrica', cid => \@cids});
}

$log->out('DONE');
