#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '1 мин',
        comment => 'Все русский домены переводим в puny-code',
    }

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use DBTools;
use Tools qw/is_production/;
use ScriptHelper;

use Yandex::IDN;

$log->out('START');

my $domains = get_all_sql(PPCDICT, "SELECT domain, filter_domain FROM mirrors_correction");

for my $domain (@{$domains}) {
    my $ascii_domain = Yandex::IDN::idn_to_ascii($domain->{domain});
    my $ascii_filter_domain = Yandex::IDN::idn_to_ascii($domain->{filter_domain});
    next if ($domain->{domain} eq $ascii_domain && $domain->{filter_domain} eq $ascii_filter_domain);

    if ($ascii_domain eq $ascii_filter_domain ||
        get_one_field_sql(PPCDICT, "SELECT 1 FROM mirrors_correction where domain = ?", $ascii_domain )) {

        do_delete_from_table(PPCDICT, 'mirrors_correction', where => {domain => $domain->{domain}});
        $log->out(sprintf("removed domain: %s => domain: %s filter_domain: %s\n", $domain->{domain}, $ascii_domain, $ascii_filter_domain));
        next;
    }

    do_update_table(PPCDICT, 'mirrors_correction', {domain => $ascii_domain, filter_domain => $ascii_filter_domain}, where => {domain => $domain->{domain}});
    $log->out(sprintf("updated domain: %s => domain: %s filter_domain: %s\n", $domain->{domain}, $ascii_domain, $ascii_filter_domain));
    if (!is_production()) {
        do_replace_into_table(PPCDICT, 'mirrors', {domain => $ascii_domain, mirror => $ascii_filter_domain});
        $log->out(sprintf("replace into mirrors domain: %s mirror: %s\n", , $ascii_domain, $ascii_filter_domain));
    }

}

$log->out('FINISH');
exit(0);