#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '3 сек',
        comment => 'убираем пробелы из логинов; на консоль ничего не пишет',
    }

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use DBTools;
use ScriptHelper;

use Primitives;
use Tools;
use User;

$log->out('START');

$log->out('Fetching logins with spaces');
my $data = get_all_sql(PPC_HEAVY, 'SELECT uid, login FROM users WHERE login LIKE "% %"');
unless ($data && @$data) {
    $log->warn('No logins found');
    exit 0;
}

$log->out('Fetching logins as saved in passport');
for my $row(@$data) {
    my $new_login = $row->{login};
    smartstrip($new_login);
    $log->out(qq!Changing login of user $row->{uid} from "$row->{login}" to "$new_login"!);
    create_update_user($row->{uid}, {login => $new_login});
}

$log->out('DONE');
