#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'на devtest: 43 мин',
        comment => 'заполняем ppclog.log_strategy_change стратегиями на существующих кампаниях',
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use Tools;
use ScriptHelper;

use Data::Dumper;

# -----------------------------------------------------------------------------
sub main {
    my $MAX_CAMPS = 10;

    $log->out("start");

    for my $iter (0 .. $MAX_CAMPS - 1) {
        my $camps = get_all_sql(PPC_HEAVY,
                                     "select c.cid, c.uid,
                                             autobudget, autobudget_sum, autobudget_bid, strategy_min_price,
                                             autobudget_avg_bid, autobudget_limit_clicks,
                                             autobudget_goal_id, strategy_no_premium,
                                             co.is_search_stop, co.strategy
                                      from campaigns c join camp_options co using(cid)
                                      where statusEmpty = 'No'
                                        and (cid mod $MAX_CAMPS) = ?
                                      order by cid
                                     ", $iter);

        $log->out(sprintf "select %i campaigns (iter: $iter)", scalar @$camps);

        for my $row (@$camps) {
            my $uid = delete $row->{uid};
            my $cid = delete $row->{cid};

            # уже успели сохранить изменение стратегии
            next if get_one_field_sql(PPCLOG, "select 1 from log_strategy_change where cid = ?", $cid);

            log_strategy_change($uid, $cid, {
                new => {map {$_ => $row->{$_}}
                        grep {$row->{$_}}
                        keys %$row
                       }
            });

            $log->out("$uid $cid $iter");
        }
    }

    $log->out("finish");
}

# -----------------------------------------------------------------------------
main();
