#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
[{
        webstop => 0,
        type => 'sql',
        db => "ppc",
        sql => "CREATE TABLE `bids_phraseid_associate` (
                  `cid` int(10) unsigned NOT NULL,
                  `bid` int(10) unsigned NOT NULL,
                  `bids_id` int(10) unsigned NOT NULL,
                  `PhraseID` int(10) unsigned NOT NULL,
                  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                  PRIMARY KEY  (`cid`,`bid`,`PhraseID`,`logtime`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8",
        time_estimate => "1 секунда",
        when => 'before',
        comment => 'Начинаем сохранять соответствие bids.id => PhraseID для статистики'
    },
    {
        type => 'script',
        when => 'after',
        time_estimate => 'на devtest: ~3 часов',
        comment => 'заполняет таблицу bids_phraseid_associate начальными данными (пишет лог), выполнять в часы пониженной нагрузки -- лучше после 18-00',
}]

=cut

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

$log->warn("Start!");

my @TBL = ( # скопировано (c) 20120116_copy_bsIdHistory.pl
    {name => 'bids', key => 'id', chunk => 10_000},
    {name => 'bids_arc', key => 'cid', chunk => 10_000},
);

for my $tbl (@TBL) {
    my ($min_id, $max_id) = get_one_line_array_sql(PPC_HEAVY, "SELECT min($tbl->{key}), max($tbl->{key}) FROM $tbl->{name}");
    $log->out("start process table $tbl->{name}, max_id=$max_id");
    while($min_id <= $max_id) {
        my $cnt = do_insert_select_sql(PPC_HEAVY,
                "INSERT IGNORE INTO bids_phraseid_associate (cid, bid, PhraseID, bids_id, logtime) VALUES %s",
                "SELECT cid, bid, PhraseID, id, modtime
                  FROM $tbl->{name}
                  WHERE IFNULL(PhraseID, 0) != 0
                    AND $tbl->{key} between $min_id and ".($min_id + $tbl->{chunk} - 1)
                ,
                dbw => PPC
            );
        $log->out("Moved $cnt rows for $tbl->{name} where $min_id <= $tbl->{key} < ".($min_id + $tbl->{chunk} - 1));
        $min_id += $tbl->{chunk};
    }
}

$log->warn("End.");