#!/usr/bin/perl -w

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script', 
        when => 'after',
        time_estimate => '1 min',
        comment => "добавляет в таблицу логов по пользователем новое поле - application_id, в консоль ничего не пишет",
    }


=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Time::HiRes qw/time sleep/;
use ScriptHelper;

use Settings;
use Yandex::DBTools;

$log->out("start modifiyng logapi_users");

for my $table (reverse sort @{get_one_column_sql(PPCLOG, "show tables like 'logapi_users%'")}) {
    $log->out($table);

    $log->out("already done"), next if grep {$_->{Field} eq 'application_id'} @{get_all_sql(PPCLOG, "DESC $table")};

    my $arch_flag = scalar grep {$_->{Field} eq 'operator_uid' && !$_->{Key}} @{get_all_sql(PPCLOG, "DESC $table")};

    $log->out("start alter");
    my $t = time();
    if (!$arch_flag) {
        $log->out("not archived table");
        do_sql(PPCLOG, "alter table $table add column `application_id` varchar(50) default '', 
                                       drop PRIMARY KEY,
                                       add PRIMARY KEY  (`date`,`client_uid`,`operator_uid`,`api_version`, `application_id`), 
                                       add KEY (`operator_uid`,`application_id`)");
    } else {
        $log->out("archived table");
        do_sql(PPCLOG, "alter table $table add column `application_id` varchar(50) default ''");
    }
    my $sleep = time() - $t;
    $log->out("start sleep $sleep");
    sleep($sleep);
}

$log->out("stop modifiyng logapi_users");
