#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'на devtest: 90 сек',
        comment => 'копируем ppclog.log_strategy_change -> monitor.log_strategy_change',
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use Tools;
use ScriptHelper;

use Data::Dumper;

# -----------------------------------------------------------------------------
sub main {
    $log->out("start");
    my $MAX_ITER = 20;

    # +-----------+-------------+------+-----+-------------------+-------+
    # | Field     | Type        | Null | Key | Default           | Extra |
    # +-----------+-------------+------+-----+-------------------+-------+
    # | uid       | bigint(20)  | NO   |     | 0                 |       |
    # | cid       | bigint(20)  | NO   | MUL | 0                 |       |
    # | data_json | text        | NO   |     | NULL              |       |
    # | ip        | varchar(16) | NO   |     |                   |       |
    # | logtime   | timestamp   | NO   | MUL | CURRENT_TIMESTAMP |       |
    # +-----------+-------------+------+-----+-------------------+-------+
    for my $iter (0 .. $MAX_ITER - 1) {
        my $all_logs = [map {[$_->{uid}, $_->{cid}, $_->{data_json}, $_->{ip}, $_->{logtime}]}
                        @{get_all_sql(PPCLOG, "select *
                                               from log_strategy_change
                                               where (cid mod $MAX_ITER) = ?
                                               order by cid
                                              ", $iter
                                     )}
                       ];
        $log->out(sprintf "select %i rows (iter: $iter)", scalar @$all_logs);

        my $cnt = do_mass_insert_sql(MONITOR, 'insert into log_strategy_change (uid, cid, data_json, ip, logtime) values %s', $all_logs);
        $log->out("copy $cnt rows (iter: $iter)");
    }

    $log->out("finish");
}

# -----------------------------------------------------------------------------
main();
