#!/usr/bin/perl -w

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'на devtest: 5 минут',
        comment => 'исправляет домен pixel.everesttech.net на правильные и переотправляет в БК, в консоль ничего не пишет',
    }

=cut

use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use URLDomain;
use ScriptHelper;

use URI::Escape;

=pod EXAMPLE URL

http://pixel.everesttech.net/2724/c?
    ev_sid=90&ev_cl=68c5378b16606d6ea9f31acdf9dd8025&ev_lx={param1}&ev_crx={param2}&ev_ln={keyword}&ev_mt={source_type}&ev_pos={position}&ev_pt={position_type}
    &url=http%3A//www.lamoda.ru/%3Futm_source%3DYDirect%26utm_medium%3Dcpc%26utm_campaign%3DCategory%2B%25CE%25E1%25F3%25E2%25FC%2BRegions%26utm_content%3DYDirect-Ad%26utm_term%3D%25C7%25E0%25EA%25E0%25E7%25E0%25F2%25FC%2520%25EE%25E1%25F3%25E2%25FC%2520%25EE%25ED%25EB%25E0%25E9%25ED%2520%25ED%25E0%2520Lamoda_phrase%26wt_mc%3DYDirect.Category%2B%25CE%25E1%25F3%25E2%25FC%2BRegions

=cut

my %COLLECT;

$log->out("start");

my $res = get_all_sql(PPC, "select bid, domain, href from banners where reverse_domain = reverse('pixel.everesttech.net')");
foreach my $r (@$res) {
    my ($redirect_href) = $r->{href} =~ /\&url=([^&]+)/;
    my $decoded_href = uri_unescape($redirect_href);
    my $new_domain = get_Host($decoded_href);


    if ($new_domain && $new_domain =~ /(?:www)?(?:lamoda|avito|tui|vkotravel|torg|tv\-club|appliances\.dostavka|edarling|computers\.dostavka|dostavka)\.(?:ru|com|ua)$/) {
        # для надежности - исправляем только перечисленные домены (получены опытным путем)
        push @{ $COLLECT{ $new_domain } }, $r->{bid};
    } else {
         $log->out(join(", ", "BAD_DOMAIN", $r->{bid}, $r->{href}, $redirect_href, $decoded_href, $new_domain));
    }
}

$log->out("finish collect data");
$log->out("start update banners");

foreach my $ndomain (keys %COLLECT) {
    $log->out("processing domain $ndomain");
    $log->out("count banners: ".scalar(@{$COLLECT{$ndomain}}));

    my $ndomain_reverse = join('', reverse(split //, $ndomain));

    while (my @bids = splice @{$COLLECT{$ndomain}}, 0, 3000) {

        $log->out("update $ndomain: ".join(',', @bids));

        do_update_table(PPC, "banners", { domain => $ndomain
                                            , reverse_domain => $ndomain_reverse
                                            , statusBsSynced => 'No'
                                            , lastChange__dont_quote => 'lastChange'
                                        }
                                        , where => { bid => \@bids, domain => 'pixel.everesttech.net' });
        sleep(3);
    }
}