#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '4 минуты',
        comment => 'отрывает доп.ссылки от баннеров без ссылок; в консоль ничего не пишет',
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use ModerationQueue;
use Data::Dumper;

$log->out('START');

my $data_by_cid = get_all_sql(PPC_HEAVY, 'SELECT bid, cid, sitelinks_set_id, statusSitelinksModerate, statusBsSynced FROM banners WHERE sitelinks_set_id > 0 AND IFNULL(href,"") = ""');
if ($data_by_cid && @$data_by_cid) {
    $log->out('Got ' . @$data_by_cid . ' banners');
    my %cid2bids;
    for my $banner(@$data_by_cid) {
        local $Data::Dumper::Indent = 0;
        $log->out(Dumper $banner);
        do_sql(PPC, 'UPDATE banners SET sitelinks_set_id=NULL, statusSitelinksModerate="New", statusBsSynced = "No", LastChange=LastChange WHERE bid = ? AND cid = ? AND sitelinks_set_id > 0 AND IFNULL(href,"") = ""', $banner->{bid}, $banner->{cid});
        push @{$cid2bids{$banner->{cid}}}, $banner->{bid};
    }
    while (my ($cid, $bids) = each %cid2bids) {
        del_sitelinks_sets_from_moderate($cid, $bids);
    }
}

$log->out('FINISH');
