#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'на devtest: 5 сек',
        comment => 'исправляет users.lastchange: значения из будущего заменяет на now()',
    }

=cut

use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper 'Yandex::Log' => [date_suf => "%Y%m%d", tee => 1];

$log->out("start");

my $uids = get_one_column_sql(PPC, "select uid from users where lastchange > now()") || [];
$log->out("found ".scalar(@$uids)." users: ".join(", ", @$uids));
if (@$uids > 1000) {
    $log->die("Error: Too many uids");
}
do_sql(PPC, ["UPDATE users SET lastchange = now()", WHERE => {uid => $uids}]);

$log->out("finish");
