#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '4 минуты',
        comment => 'заполняем campaigns.ProductID кусками по 10_000',
    }

=cut

use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

$log->out("start");

my $min_cid = 0;
my $max_cid = get_one_field_sql(PPC, 'select max(cid) from campaigns');
my $count   = 0;
my $block   = 10_000;
do
{
    $count = do_sql(PPC, ["update campaigns c join products prod on c.type = prod.type set c.ProductID = prod.ProductID",
        where => { 'c.ProductID__is_null' => 1, 'c.cid__between' => [$min_cid, $min_cid + $block] }]);
    $log->out("$min_cid: $count rows updated");
    $min_cid += $block;
    sleep 1;
} while ($min_cid < $max_cid);

$log->out("finish");

