#!/usr/bin/perl -w

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script', 
        when => 'after',
        time_estimate => '4 min',
        comment => "Добавляет пропущенных ранее пользователей DC в таблицу logapi_users_201110 за 13 - 17 октября. В консоль ничего не пишет",
    }


=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use ScriptHelper;
use Settings;
use Yandex::DBTools;
use Yandex::ListUtils;

$log->out('start repairing');

$log->out('searching for uids to add');

# application_id Директ.Коммандера
my $app_id = 'c906d379328e4541a6d06e4894f2a03b';

my $table_name = 'logapi_users_201110';

my $mdata_uids = [];

for my $suffix (13..17) {
    my $tabledate = "201110$suffix";
    $log->out("retrieving data from table logapi_$tabledate");
    my $uids = get_one_column_sql(PPCLOG, "select distinct uid from logapi_$tabledate where application_id = ?", $app_id);

    my $uids_insert = get_one_column_sql(PPCLOG, [ "select distinct uid from logapi_$tabledate", where => {uid => $uids, application_id__ne => $app_id}]);

    foreach my $uid (@$uids_insert) {
        push @$mdata_uids, [$uid, 0, $tabledate, 1, 4, $app_id];
    }

    my $uids_update = xdiff($uids, $uids_insert);

    $log->out('rows to update: '.scalar @$uids_update);

    do_update_table(PPCLOG, "logapi_users_201110", {application_id => $app_id}, where => {operator_uid => $uids_update, date => $tabledate} );
}

if ($mdata_uids && scalar @$mdata_uids) {
    $log->out('rows to add: '.scalar @$mdata_uids);

    # делаем запись в таблицу логов по пользователям
    my $sql = "insert ignore into $table_name (operator_uid, client_uid, date, cnt, api_version, application_id) values %s";
    my $lines = do_mass_insert_sql(PPCLOG, $sql, $mdata_uids);

    $log->out("rows added: $lines");
}

$log->out('stop repairing');
