#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'на devtest: 56 sec',
        comment => 'переотправляем в БК все кампании (после исправления временного таргетинга)',
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

# -----------------------------------------------------------------------------
sub main {
    my $PARTS = 10;
    $log->out("start");
    my $all_cnt = 0;

    for my $i (0 .. $PARTS - 1) {
        my $cids = get_one_column_sql(PPC, "select cid
                                            from campaigns
                                            where OrderID > 0
                                              and sum - sum_spent > 0.001
                                              and cid mod ? = ?", $PARTS, $i) || [];

        $log->out($cids);
        my $insert_cnt = do_mass_insert_sql(PPC, "insert into bs_resync_queue (cid) values %s ON DUPLICATE KEY UPDATE cid = VALUES(cid)", [map {[$_]} @$cids]);
        $log->out({i => $i, cids_count => scalar(@$cids), insert_count => $insert_cnt});
        $all_cnt += $insert_cnt;
    }

    $log->out("resend $all_cnt campaigns");
    $log->out("end");
}

# -----------------------------------------------------------------------------
main();
