#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;


=head1 DEPLOY

# approved by zhur
# .migr
[{
  webstop => "0",
  type => 'sql',
  db => "ppcdict",
  time_estimate => "1 sec",
  when => 'before',
  sql => [
         "CREATE TABLE `serp_geo_stat` (
              `region` int unsigned NOT NULL default '0',
              `coef` double NOT NULL,
              PRIMARY KEY  (`region`)
            ) ENGINE=InnoDB", 
    ]
},
    {
        type => 'script',
        when => 'after',
        time_estimate => '5 sec',
        comment => 'заполняем таблицу serp_geo_staa',
    }

]
=cut
my $data = [
            [213, 0.173124],
            [2, 0.056423],
            [187, 0.034414],
            [65, 0.023732],
            [143, 0.023280],
            [54, 0.018023],
            [225, 0.016831],
            [40, 0.015885],
            [157, 0.014477],
            [118, 0.014455],
            [1, 0.014239],
            [47, 0.012391],
            [62, 0.011418],
            [56, 0.009949],
            [162, 0.009635],
            [66, 0.008288],
            [43, 0.008267],
            [35, 0.008253],
            [193, 0.008212],
            [39, 0.007860],
            [147, 0.007687],
            [172, 0.007617],
            [17, 0.007489],
            [38, 0.007066],
            [52, 0.006530],
            [50, 0.006207],
            [197, 0.006031],
            [51, 0.006019],
            [3, 0.005902],
            [145, 0.005870],
            [75, 0.005512],
            [142, 0.005480],
            [10313, 0.005270],
            [26, 0.005115],
            [63, 0.005101],
            [11162, 0.004717],
            [141, 0.004495],
            [10262, 0.004415],
            [194, 0.004336],
            [55, 0.004332],
            [64, 0.004322],
            [240, 0.004216],
            [15, 0.004159],
            [11108, 0.004105],
            [29633, 0.004022],
            [22, 0.004018],
            [67, 0.003987],
            [195, 0.003807],
            [10466, 0.003761],
            [164, 0.003745],
            [49, 0.003675],
            [149, 0.003620],
            [10995, 0.003567],
            [11, 0.003484],
            [76, 0.003457],
            [11029, 0.003340],
            [11474, 0.003339],
            [10277, 0.003288],
            [46, 0.003275],
            [9, 0.003268],
            [11119, 0.003216],
            [44, 0.003184],
            [10253, 0.003181],
            [11131, 0.003161],
            [155, 0.003129],
            [59, 0.003112],
            [36, 0.003065],
            [144, 0.003008],
            [16, 0.002933],
            [11146, 0.002840],
            [237, 0.002829],
            [14, 0.002813],
            [23, 0.002797],
            [11084, 0.002731],
            [163, 0.002728],
            [45, 0.002637],
            [11193, 0.002637],
            [4, 0.002565],
            [5, 0.002518],
            [11111, 0.002497],
            [48, 0.002493],
            [960, 0.002475],
            [146, 0.002450],
            [99, 0.002384],
            [20, 0.002344],
            [192, 0.002329],
            [10274, 0.002288],
            [10347, 0.002259],
            [37, 0.002220],
            [10, 0.002201],
            [18, 0.002157],
            [21620, 0.002129],
            [236, 0.002110],
            [12, 0.002100],
            [191, 0.002078],
            [6, 0.002068],
            [222, 0.002056],
            [190, 0.002014],
            [973, 0.001967],
            [53, 0.001961],
            [11225, 0.001943],
            [959, 0.001892],
            [10747, 0.001847],
            [10309, 0.001840],
            [21, 0.001811],
            [13, 0.001787],
            [235, 0.001724],
            [148, 0.001724],
            [10291, 0.001679],
            [41, 0.001656],
            [158, 0.001628],
            [11148, 0.001623],
            [10335, 0.001603],
            [42, 0.001574],
            [29630, 0.001571],
            [25, 0.001525],
            [33, 0.001506],
            [11508, 0.001432],
            [11235, 0.001428],
            [11475, 0.001424],
            [19, 0.001417],
            [11069, 0.001417],
            [10366, 0.001381],
            [10306, 0.001372],
            [10317, 0.001369],
            [8, 0.001356],
            [10174, 0.001347],
            [10758, 0.001332],
            [239, 0.001311],
            [68, 0.001291],
            [10295, 0.001286],
            [103775, 0.001285],
            [24, 0.001275],
            [20273, 0.001242],
            [10363, 0.001219],
            [131, 0.001218],
            [29632, 0.001204],
            [10435, 0.001201],
            [10445, 0.001182],
            [1095, 0.001181],
            [11409, 0.001179],
            [11503, 0.001178],
            [198, 0.001165],
            [221, 0.001155],
            [964, 0.001142],
            [29575, 0.001128],
            [963, 0.001118],
            [101739, 0.001106],
            [7, 0.001088],
            [11168, 0.001076],
            [11481, 0.001069],
            [11116, 0.001066],
            [10693, 0.001057],
            [10502, 0.001055],
            [10951, 0.001042],
            [10849, 0.001018],
            [968, 0.001003],
            [20571, 0.000981],
            [159, 0.000971],
            [10649, 0.000970],
            [11453, 0.000965],
            [11095, 0.000959],
            [11426, 0.000957],
            [21609, 0.000951],
            [165, 0.000940],
            [965, 0.000929],
            [20536, 0.000901],
            [132, 0.000888],
            [10305, 0.000875],
            [962, 0.000875],
            [10418, 0.000872],
            [10511, 0.000866],
            [30, 0.000859],
            [11079, 0.000850],
            [28, 0.000846],
            [10841, 0.000834],
            [73, 0.000831],
            [1091, 0.000831],
            [179, 0.000818],
            [10365, 0.000816],
            [171, 0.000800],
            [10298, 0.000780],
            [10303, 0.000778],
            [10357, 0.000770],
            [29629, 0.000768],
            [966, 0.000757],
            [10802, 0.000754],
            [21094, 0.000748],
            [971, 0.000746],
            [11282, 0.000741],
            [10343, 0.000741],
            [11375, 0.000739],
            [10945, 0.000739],
            [37133, 0.000737],
            [10750, 0.000733],
            [10897, 0.000731],
            [20809, 0.000721],
            [20221, 0.000709],
            [202, 0.000672],
            [961, 0.000667],
            [10641, 0.000655],
            [10658, 0.000642],
            [11127, 0.000627],
            [10379, 0.000623],
            [10765, 0.000619],
            [21774, 0.000604],
            [10355, 0.000602],
            [10472, 0.000602],
            [11143, 0.000591],
            [974, 0.000590],
            [77, 0.000588],
            [10345, 0.000573],
            [21619, 0.000568],
            [10393, 0.000565],
            [10687, 0.000564],
            [10716, 0.000561],
            [10369, 0.000560],
            [11500, 0.000557],
            [94, 0.000554],
            [11091, 0.000553],
            [11231, 0.000550],
            [976, 0.000535],
            [20554, 0.000529],
            [11156, 0.000527],
            [10904, 0.000515],
            [104628, 0.000513],
            [10838, 0.000503],
            [10830, 0.000480],
            [10519, 0.000478],
            [124, 0.000476],
            [10376, 0.000475],
            [10928, 0.000470],
            [10590, 0.000465],
            [11287, 0.000462],
            [11067, 0.000461],
            [21050, 0.000456],
            [24876, 0.000447],
            [969, 0.000435],
            [178, 0.000434],
            [10839, 0.000433],
            [11207, 0.000433],
            [11171, 0.000432],
            [10000, 0.000428],
            [10699, 0.000424],
            [10722, 0.000419],
            [80, 0.000418],
            [10940, 0.000417],
            [24885, 0.000409],
            [10871, 0.000402],
            [20222, 0.000400],
            [970, 0.000400],
            [975, 0.000393],
            [10891, 0.000393],
            [10318, 0.000390],
            [10487, 0.000387],
            [137, 0.000385],
            [11164, 0.000384],
            [154, 0.000380],
            [10398, 0.000380],
            [10664, 0.000370],
            [100, 0.000370],
            [11212, 0.000369],
            [11499, 0.000367],
            [103763, 0.000366],
            [10408, 0.000366],
            [11176, 0.000363],
            [104596, 0.000362],
            [101, 0.000357],
            [10074, 0.000356],
            [21773, 0.000356],
            [10710, 0.000356],
            [967, 0.000354],
            [11070, 0.000348],
            [9999, 0.000347],
            [11155, 0.000345],
            [21623, 0.000342],
            [1104, 0.000341],
            [37147, 0.000336],
            [11147, 0.000334],
            [11464, 0.000332],
            [74, 0.000329],
            [10734, 0.000323],
            [11036, 0.000322],
            [104396, 0.000317],
            [11393, 0.000316],
            [10426, 0.000314],
            [24893, 0.000313],
            [10842, 0.000310],
            [11302, 0.000309],
            [21775, 0.000309],
            [10635, 0.000307],
            [995, 0.000303],
            [10959, 0.000303],
            [972, 0.000302],
            [10522, 0.000302],
            [10752, 0.000302],
            [20271, 0.000301],
            [11480, 0.000300],
            [11351, 0.000298],
            [10645, 0.000297],
            [977, 0.000296],
            [10471, 0.000295],
            [10832, 0.000294],
            [10367, 0.000286],
            [78, 0.000279],
            [11485, 0.000278],
            [10713, 0.000277],
            [11214, 0.000274],
            [10735, 0.000270],
            [20235, 0.000269],
            [28655, 0.000268],
            [11114, 0.000267],
            [10668, 0.000266],
            [11013, 0.000266],
            [153, 0.000262],
            [27768, 0.000262],
            [1093, 0.000256],
            [11057, 0.000249],
            [20540, 0.000245],
            [10467, 0.000244],
            [10115, 0.000240],
            [10285, 0.000238],
            [20720, 0.000236],
            [10097, 0.000235],
            [21949, 0.000235],
            [11115, 0.000234],
            [11470, 0.000234],
            [11406, 0.000233],
            [10494, 0.000232],
            [11469, 0.000231],
            [21460, 0.000230],
            [10741, 0.000228],
            [101514, 0.000227],
            [24881, 0.000225],
            [10371, 0.000225],
            [21622, 0.000223],
            [10944, 0.000223],
            [10604, 0.000222],
            [216, 0.000219],
            [10864, 0.000219],
            [134, 0.000218],
            [10489, 0.000218],
            [1056, 0.000212],
            [98, 0.000211],
            [1094, 0.000209],
            [100500, 0.000209],
            [24902, 0.000209],
            [181, 0.000209],
            [10620, 0.000209],
            [169, 0.000208],
            [84, 0.000205],
            [10865, 0.000205],
            [11230, 0.000204],
            [10738, 0.000203],
            [10705, 0.000198],
            [10020, 0.000198],
            [10394, 0.000198],
            [205, 0.000197],
            [10946, 0.000197],
            [21645, 0.000197],
            [11062, 0.000196],
            [20728, 0.000195],
            [10743, 0.000195],
            [20088, 0.000194],
            [10939, 0.000194],
            [11080, 0.000191],
            [10748, 0.000189],
            [10754, 0.000188],
            [21276, 0.000186],
            [28539, 0.000185],
            [29403, 0.000182],
            [10646, 0.000182],
            [11217, 0.000182],
            [93, 0.000181],
            [20196, 0.000181],
            [27370, 0.000181],
            [21647, 0.000181],
            [10507, 0.000179],
            [27704, 0.000179],
            [11311, 0.000178],
            [125, 0.000177],
            [20575, 0.000175],
            [200, 0.000174],
            [10860, 0.000174],
            [10723, 0.000174],
            [10448, 0.000173],
            [11159, 0.000171],
            [11010, 0.000170],
            [103766, 0.000168],
            [10562, 0.000168],
            [11476, 0.000166],
            [58, 0.000166],
            [24901, 0.000165],
            [10405, 0.000163],
            [11319, 0.000163],
            [21624, 0.000162],
            [10853, 0.000162],
            [29411, 0.000160],
            [104136, 0.000160],
            [10315, 0.000159],
            [20537, 0.000158],
            [10942, 0.000157],
            [10131, 0.000156],
            [57, 0.000156],
            [10761, 0.000156],
            [10740, 0.000155],
            [100488, 0.000155],
            [11443, 0.000155],
            [10650, 0.000155],
            [10933, 0.000155],
            [101472, 0.000154],
            [10894, 0.000153],
            [11477, 0.000149],
            [24898, 0.000149],
            [11153, 0.000149],
            [11064, 0.000149],
            [10739, 0.000148],
            [11273, 0.000148],
            [27101, 0.000147],
            [11063, 0.000147],
            [21126, 0.000146],
            [11463, 0.000145],
            [10824, 0.000144],
            [10308, 0.000144],
            [20718, 0.000142],
            [11310, 0.000141],
            [10314, 0.000141],
            [10300, 0.000141],
            [10812, 0.000141],
            [103767, 0.000139],
            [11437, 0.000138],
            [10144, 0.000138],
            [10756, 0.000137],
            [11218, 0.000136],
            [11175, 0.000135],
            [10358, 0.000135],
            [135, 0.000135],
            [10425, 0.000134],
            [28896, 0.000134],
            [20192, 0.000133],
            [28865, 0.000133],
            [10811, 0.000132],
            [21191, 0.000131],
            [994, 0.000131],
            [10477, 0.000131],
            [11184, 0.000129],
            [24900, 0.000127],
            [20684, 0.000127],
            [10987, 0.000127],
            [11056, 0.000127],
            [28948, 0.000127],
            [10857, 0.000126],
            [11456, 0.000126],
            [11228, 0.000125],
            [10095, 0.000124],
            [20530, 0.000124],
            [101458, 0.000124],
            [28887, 0.000123],
            [27687, 0.000121],
            [208, 0.000119],
            [10108, 0.000119],
            [103764, 0.000119],
            [10281, 0.000119],
            [103765, 0.000119],
            [11450, 0.000119],
            [10819, 0.000119],
            [97, 0.000118],
            [11229, 0.000118],
            [11482, 0.000118],
            [20707, 0.000118],
            [180, 0.000115],
            [11174, 0.000113],
            [11132, 0.000113],
            [11471, 0.000113],
            [20826, 0.000112],
            [29577, 0.000112],
            [10689, 0.000111],
            [24904, 0.000111],
            [11186, 0.000111],
            [96, 0.000109],
            [11309, 0.000109],
            [20143, 0.000108],
            [10324, 0.000107],
            [11505, 0.000107],
            [27693, 0.000106],
            [20555, 0.000106],
            [10691, 0.000106],
            [20237, 0.000106],
            [28583, 0.000105],
            [79, 0.000104],
            [21944, 0.000104],
            [29634, 0.000103],
            [29631, 0.000102],
            [29322, 0.000102],
            [21396, 0.000102],
            [11150, 0.000101],
            [102602, 0.000100],
            [10950, 0.000100],
            [11160, 0.000099],
            [10762, 0.000099],
            [11451, 0.000098],
            [11264, 0.000098],
            [11494, 0.000097],
            [123, 0.000096],
            [20086, 0.000096],
            [21632, 0.000095],
            [21772, 0.000095],
            [28992, 0.000094],
            [20224, 0.000094],
            [10492, 0.000092],
            [10737, 0.000091],
            [28892, 0.000091],
            [103778, 0.000091],
            [21187, 0.000090],
            [10024, 0.000090],
            [10480, 0.000090],
            [223, 0.000089],
            [10130, 0.000089],
            [27051, 0.000088],
            [10854, 0.000088],
            [29053, 0.000088],
            [21353, 0.000087],
            [101512, 0.000087],
            [10122, 0.000086],
            [21641, 0.000086],
            [21368, 0.000086],
            [24884, 0.000085],
            [11043, 0.000085],
            [10783, 0.000084],
            [10463, 0.000084],
            [86, 0.000084],
            [11232, 0.000084],
            [11024, 0.000083],
            [10536, 0.000083],
            [91, 0.000082],
            [20721, 0.000082],
            [10721, 0.000082],
            [90, 0.000082],
            [24903, 0.000081],
            [11251, 0.000081],
            [20659, 0.000081],
            [101429, 0.000081],
            [27417, 0.000080],
            [26034, 0.000080],
            [11473, 0.000080],
            [21274, 0.000080],
            [20657, 0.000080],
            [27099, 0.000080],
            [10993, 0.000080],
            [11240, 0.000079],
            [102563, 0.000079],
            [11256, 0.000078],
            [10292, 0.000078],
            [10537, 0.000078],
            [104623, 0.000077],
            [103780, 0.000077],
            [10592, 0.000077],
            [11266, 0.000076],
            [10619, 0.000076],
            [11501, 0.000076],
            [100513, 0.000076],
            [27784, 0.000076],
            [10574, 0.000075],
            [103772, 0.000075],
            [10937, 0.000075],
            [27555, 0.000075],
            [27165, 0.000075],
            [103769, 0.000075],
            [10745, 0.000074],
            [27092, 0.000074],
            [11188, 0.000074],
            [10552, 0.000073],
            [104422, 0.000073],
            [103776, 0.000073],
            [20529, 0.000073],
            [117, 0.000073],
            [10403, 0.000073],
            [21392, 0.000072],
            [10453, 0.000072],
            [10474, 0.000072],
            [103770, 0.000072],
            [20553, 0.000072],
            [246, 0.000072],
            [21356, 0.000071],
            [20743, 0.000071],
            [10719, 0.000071],
            [11055, 0.000070],
            [11291, 0.000070],
            [103563, 0.000070],
            [21611, 0.000070],
            [10129, 0.000070],
            [11333, 0.000070],
            [27118, 0.000069],
            [27838, 0.000069],
            [28051, 0.000069],
            [21156, 0.000069],
            [20765, 0.000068],
            [24890, 0.000068],
            [10672, 0.000068],
            [20541, 0.000068],
            [103564, 0.000068],
            [11172, 0.000068],
            [28562, 0.000068],
            [0, 0.000068],
            [28250, 0.000067],
            [10653, 0.000067],
            [10892, 0.000067],
            [10402, 0.000067],
            [20255, 0.000067],
            [11316, 0.000067],
            [20544, 0.000066],
            [177, 0.000066],
            [203, 0.000066],
            [102, 0.000066],
            [20576, 0.000066],
            [103768, 0.000066],
            [20539, 0.000065],
            [10385, 0.000065],
            [215, 0.000065],
            [24871, 0.000065],
            [26446, 0.000064],
            [21521, 0.000064],
            [238, 0.000064],
            [10742, 0.000064],
            [102566, 0.000064],
            [101673, 0.000063],
            [10558, 0.000063],
            [11011, 0.000063],
            [21945, 0.000063],
            [11278, 0.000063],
            [10381, 0.000063],
            [217, 0.000062],
            [20161, 0.000062],
            [21154, 0.000062],
            [103774, 0.000062],
            [11177, 0.000062],
            [10935, 0.000062],
            [10656, 0.000062],
            [21457, 0.000062],
            [10013, 0.000062],
            [11009, 0.000061],
            [28620, 0.000061],
            [21311, 0.000061],
            [27665, 0.000061],
            [168, 0.000061],
            [27598, 0.000060],
            [11161, 0.000060],
            [102564, 0.000060],
            [11007, 0.000059],
            [103787, 0.000059],
            [100814, 0.000059],
            [20682, 0.000059],
            [11220, 0.000058],
            [28531, 0.000058],
            [21487, 0.000058],
            [28682, 0.000058],
            [10322, 0.000056],
            [20115, 0.000056],
            [21417, 0.000056],
            [10021, 0.000056],
            [20862, 0.000055],
            [10509, 0.000055],
            [11192, 0.000055],
            [10540, 0.000054],
            [1106, 0.000054],
            [10879, 0.000054],
            [206, 0.000054],
            [27389, 0.000053],
            [101419, 0.000053],
            [20230, 0.000053],
            [20552, 0.000053],
            [120, 0.000053],
            [21159, 0.000053],
            [10057, 0.000052],
            [100489, 0.000052],
            [10410, 0.000052],
            [24889, 0.000052],
            [21510, 0.000052],
            [27511, 0.000052],
            [10884, 0.000052],
            [10093, 0.000051],
            [102565, 0.000051],
            [20814, 0.000050],
            [21184, 0.000050],
            [100475, 0.000050],
            [10755, 0.000050],
            [29355, 0.000050],
            [103782, 0.000050],
            [10407, 0.000050],
            [29372, 0.000050],
            [103567, 0.000049],
            [21204, 0.000049],
            [20010, 0.000048],
            [100496, 0.000048],
            [10102, 0.000048],
            [103784, 0.000048],
            [11436, 0.000047],
            [11223, 0.000047],
            [28183, 0.000047],
            [11012, 0.000047],
            [102573, 0.000046],
            [26018, 0.000046],
            [20959, 0.000046],
            [11341, 0.000046],
            [11285, 0.000046],
            [103777, 0.000045],
            [29349, 0.000045],
            [21121, 0.000045],
            [11358, 0.000045],
            [103771, 0.000045],
            [27154, 0.000045],
            [10475, 0.000044],
            [103779, 0.000044],
            [21621, 0.000044],
            [11158, 0.000044],
            [21211, 0.000044],
            [20604, 0.000044],
            [21134, 0.000043],
            [211, 0.000043],
            [21273, 0.000043],
            [20806, 0.000043],
            [102577, 0.000043],
            [11391, 0.000043],
            [28401, 0.000043],
            [21467, 0.000042],
            [21241, 0.000042],
            [11170, 0.000042],
            [20917, 0.000042],
            [10278, 0.000042],
            [10599, 0.000042],
            [11022, 0.000042],
            [10727, 0.000042],
            [11342, 0.000041],
            [102588, 0.000041],
            [20097, 0.000041],
            [10926, 0.000041],
            [21766, 0.000041],
            [21658, 0.000041],
            [10077, 0.000041],
            [20532, 0.000040],
            [10069, 0.000040],
            [20234, 0.000040],
            [11504, 0.000040],
            [20716, 0.000040],
            [21325, 0.000039],
            [27985, 0.000039],
            [100509, 0.000039],
            [20074, 0.000039],
            [21037, 0.000039],
            [10064, 0.000039],
            [11202, 0.000038],
            [11374, 0.000038],
            [27619, 0.000038],
            [101478, 0.000038],
            [21270, 0.000038],
            [20040, 0.000038],
            [10145, 0.000038],
            [10500, 0.000038],
            [10629, 0.000038],
            [21003, 0.000038],
            [20712, 0.000038],
            [103785, 0.000038],
            [100493, 0.000038],
            [20523, 0.000037],
            [11167, 0.000037],
            [103113, 0.000037],
            [10606, 0.000037],
            [29342, 0.000036],
            [20815, 0.000036],
            [27819, 0.000036],
            [20044, 0.000036],
            [10478, 0.000036],
            [11137, 0.000036],
            [10504, 0.000036],
            [102820, 0.000036],
            [103781, 0.000035],
            [24867, 0.000035],
            [11210, 0.000035],
            [10258, 0.000035],
            [11511, 0.000035],
            [20155, 0.000035],
            [104815, 0.000035],
            [21019, 0.000034],
            [10795, 0.000034],
            [103791, 0.000034],
            [10473, 0.000034],
            [10316, 0.000034],
            [11457, 0.000034],
            [20244, 0.000034],
            [27637, 0.000034],
            [11514, 0.000034],
            [20164, 0.000034],
            [10099, 0.000034],
            [11327, 0.000034],
            [102613, 0.000034],
            [20200, 0.000034],
            [11083, 0.000034],
            [21745, 0.000033],
            [20573, 0.000033],
            [119, 0.000033],
            [10896, 0.000033],
            [28185, 0.000033],
            [10728, 0.000033],
            [26314, 0.000033],
            [20776, 0.000033],
            [11276, 0.000033],
            [10846, 0.000033],
            [11058, 0.000032],
            [103783, 0.000032],
            [21416, 0.000032],
            [11090, 0.000032],
            [24873, 0.000032],
            [10923, 0.000032],
            [11352, 0.000032],
            [20785, 0.000032],
            [27728, 0.000032],
            [103566, 0.000032],
            [100541, 0.000031],
            [103790, 0.000031],
            [10387, 0.000031],
            [11098, 0.000031],
            [21206, 0.000030],
            [219, 0.000030],
            [10888, 0.000030],
            [20774, 0.000030],
            [11189, 0.000030],
            [21431, 0.000030],
            [115, 0.000029],
            [20267, 0.000029],
            [102597, 0.000029],
            [10776, 0.000029],
            [102599, 0.000029],
            [11060, 0.000029],
            [11008, 0.000029],
            [11497, 0.000029],
            [11166, 0.000029],
            [41151, 0.000029],
            [100521, 0.000029],
            [103786, 0.000029],
            [28900, 0.000029],
            [20078, 0.000028],
            [11165, 0.000028],
            [11512, 0.000028],
            [20764, 0.000028],
            [11139, 0.000028],
            [102592, 0.000028],
            [21504, 0.000028],
            [104800, 0.000028],
            [104903, 0.000028],
            [20717, 0.000028],
            [11314, 0.000028],
            [103773, 0.000028],
            [100943, 0.000027],
            [21215, 0.000027],
            [10391, 0.000027],
            [214, 0.000027],
            [102567, 0.000027],
            [20751, 0.000027],
            [10493, 0.000027],
            [10874, 0.000027],
            [24880, 0.000027],
            [209, 0.000027],
            [27448, 0.000027],
            [20645, 0.000026],
            [126, 0.000026],
            [102585, 0.000026],
            [10895, 0.000026],
            [98594, 0.000026],
            [100570, 0.000026],
            [10377, 0.000026],
            [101515, 0.000026],
            [204, 0.000026],
            [29252, 0.000026],
            [24863, 0.000026],
            [122, 0.000026],
            [10614, 0.000026],
            [103820, 0.000026],
            [11472, 0.000026],
            [20063, 0.000026],
            [102603, 0.000025],
            [10665, 0.000025],
            [20229, 0.000025],
            [11059, 0.000025],
            [129, 0.000025],
            [104151, 0.000025],
            [10770, 0.000025],
            [102890, 0.000025],
            [24866, 0.000025],
            [104894, 0.000025],
            [103793, 0.000025],
            [10965, 0.000025],
            [10725, 0.000025],
            [10858, 0.000025],
            [21081, 0.000025],
            [103798, 0.000025],
            [20676, 0.000024],
            [102574, 0.000024],
            [20156, 0.000024],
            [102803, 0.000024],
            [20754, 0.000024],
            [20572, 0.000024],
            [10704, 0.000024],
            [11447, 0.000024],
            [103789, 0.000024],
            [10380, 0.000024],
            [121, 0.000024],
            [98552, 0.000024],
            [102582, 0.000024],
            [21650, 0.000024],
            [21329, 0.000024],
            [11053, 0.000024],
            [102696, 0.000023],
            [102583, 0.000023],
            [10803, 0.000023],
            [103565, 0.000023],
            [20067, 0.000023],
            [10661, 0.000023],
            [102606, 0.000023],
            [104846, 0.000023],
            [33883, 0.000023],
            [21441, 0.000022],
            [20719, 0.000022],
            [29385, 0.000022],
            [11307, 0.000022],
            [21268, 0.000022],
            [11445, 0.000022],
            [1107, 0.000022],
            [21749, 0.000022],
            [102741, 0.000022],
            [102908, 0.000022],
            [11495, 0.000022],
            [24883, 0.000022],
            [167, 0.000021],
            [21380, 0.000021],
            [21756, 0.000021],
            [104642, 0.000021],
            [20672, 0.000021],
            [103788, 0.000021],
            [11416, 0.000021],
            [27822, 0.000021],
            [11061, 0.000021],
            [20669, 0.000021],
            [27836, 0.000021],
            [21644, 0.000021],
            [11262, 0.000021],
            [10293, 0.000020],
            [21289, 0.000020],
            [20640, 0.000020],
            [101063, 0.000020],
            [102729, 0.000020],
            [102584, 0.000020],
            [130, 0.000020],
            [103828, 0.000020],
            [102579, 0.000020],
            [11277, 0.000020],
            [11122, 0.000020],
            [20201, 0.000020],
            [29041, 0.000020],
            [20543, 0.000020],
            [102572, 0.000020],
            [10746, 0.000020],
            [37126, 0.000020],
            [11340, 0.000019],
            [11360, 0.000019],
            [10941, 0.000019],
            [20538, 0.000019],
            [10887, 0.000019],
            [20261, 0.000019],
            [11002, 0.000019],
            [27443, 0.000019],
            [103823, 0.000019],
            [20755, 0.000019],
            [101418, 0.000019],
            [21587, 0.000019],
            [103797, 0.000019],
            [26081, 0.000019],
            [24879, 0.000019],
            [21342, 0.000019],
            [103792, 0.000019],
            [102666, 0.000019],
            [24905, 0.000019],
            [28934, 0.000019],
            [11077, 0.000018],
            [20741, 0.000018],
            [1092, 0.000018],
            [21190, 0.000018],
            [28770, 0.000018],
            [10259, 0.000018],
            [102571, 0.000018],
            [103893, 0.000018],
            [11353, 0.000018],
            [103800, 0.000018],
            [20656, 0.000018],
            [10334, 0.000018],
            [21651, 0.000018],
            [103750, 0.000018],
            [27120, 0.000018],
            [102601, 0.000018],
            [103806, 0.000018],
            [24891, 0.000018],
            [103794, 0.000018],
            [21149, 0.000018],
            [100507, 0.000018],
            [10514, 0.000018],
            [102727, 0.000017],
            [11066, 0.000017],
            [22914, 0.000017],
            [103803, 0.000017],
            [21422, 0.000017],
            [103756, 0.000017],
            [102615, 0.000017],
            [103569, 0.000017],
            [104158, 0.000017],
            [103805, 0.000017],
            [10584, 0.000017],
            [10906, 0.000017],
            [21015, 0.000017],
            [116, 0.000017],
            [21265, 0.000017],
            [21551, 0.000017],
            [102622, 0.000017],
            [10496, 0.000017],
            [28543, 0.000017],
            [983, 0.000016],
            [29326, 0.000016],
            [40249, 0.000016],
            [29363, 0.000016],
            [103807, 0.000016],
            [29327, 0.000016],
            [24897, 0.000016],
            [10833, 0.000016],
            [11295, 0.000016],
            [11411, 0.000016],
            [11330, 0.000016],
            [104842, 0.000016],
            [102598, 0.000016],
            [101527, 0.000016],
            [29340, 0.000016],
            [20996, 0.000016],
            [104616, 0.000016],
            [10498, 0.000016],
            [103802, 0.000016],
            [11395, 0.000016],
            [10091, 0.000016],
            [102586, 0.000016],
            [21610, 0.000016],
            [101474, 0.000015],
            [11288, 0.000015],
            [10982, 0.000015],
            [11458, 0.000015],
            [103303, 0.000015],
            [10374, 0.000015],
            [11271, 0.000015],
            [10805, 0.000015],
            [102750, 0.000015],
            [11101, 0.000015],
            [29330, 0.000015],
            [11065, 0.000015],
            [10820, 0.000015],
            [10127, 0.000015],
            [11034, 0.000015],
            [20752, 0.000015],
            [27338, 0.000015],
            [21078, 0.000014],
            [11486, 0.000014],
            [21073, 0.000014],
            [101712, 0.000014],
            [27435, 0.000014],
            [103801, 0.000014],
            [21770, 0.000014],
            [100523, 0.000014],
            [29347, 0.000014],
            [1058, 0.000014],
            [21771, 0.000014],
            [29350, 0.000014],
            [103568, 0.000014],
            [20130, 0.000014],
            [102700, 0.000014],
            [102868, 0.000014],
            [20556, 0.000014],
            [20802, 0.000014],
            [113, 0.000014],
            [10731, 0.000014],
            [103596, 0.000014],
            [10835, 0.000014],
            [101729, 0.000014],
            [102605, 0.000013],
            [102594, 0.000013],
            [29360, 0.000013],
            [28092, 0.000013],
            [11087, 0.000013],
            [21947, 0.000013],
            [102607, 0.000013],
            [102614, 0.000013],
            [10023, 0.000013],
            [114, 0.000013],
            [21079, 0.000013],
            [10605, 0.000013],
            [103576, 0.000013],
            [102687, 0.000013],
            [102595, 0.000013],
            [21348, 0.000013],
            [11432, 0.000013],
            [27093, 0.000013],
            [21131, 0.000013],
            [11299, 0.000013],
            [102688, 0.000013],
            [102635, 0.000013],
            [21305, 0.000013],
            [102596, 0.000013],
            [11479, 0.000012],
            [102684, 0.000012],
            [102604, 0.000012],
            [102682, 0.000012],
            [104105, 0.000012],
            [20243, 0.000012],
            [102734, 0.000012],
            [27330, 0.000012],
            [10444, 0.000012],
            [20957, 0.000012],
            [29646, 0.000012],
            [21735, 0.000012],
            [20126, 0.000012],
            [20937, 0.000012],
            [11145, 0.000012],
            [11121, 0.000012],
            [101669, 0.000012],
            [20674, 0.000012],
            [102576, 0.000012],
            [101464, 0.000012],
            [20769, 0.000012],
            [29361, 0.000012],
            [101656, 0.000012],
            [104141, 0.000012],
            [103804, 0.000012],
            [103825, 0.000012],
            [104101, 0.000011],
            [103701, 0.000011],
            [103675, 0.000011],
            [102655, 0.000011],
            [104379, 0.000011],
            [11017, 0.000011],
            [11425, 0.000011],
            [20820, 0.000011],
            [10801, 0.000011],
            [102629, 0.000011],
            [102570, 0.000011],
            [28465, 0.000011],
            [3955, 0.000011],
            [28910, 0.000011],
            [2214, 0.000011],
            [102656, 0.000011],
            [103575, 0.000011],
            [102593, 0.000011],
            [104161, 0.000011],
            [104789, 0.000011],
            [20542, 0.000011],
            [26030, 0.000011],
            [104183, 0.000011],
            [29353, 0.000011],
            [102672, 0.000011],
            [98553, 0.000011],
            [24899, 0.000011],
            [102653, 0.000011],
            [102609, 0.000011],
            [102625, 0.000011],
            [10867, 0.000011],
            [29650, 0.000011],
            [20733, 0.000011],
            [27632, 0.000011],
            [102638, 0.000011],
            [103571, 0.000010],
            [10372, 0.000010],
            [103585, 0.000010],
            [20836, 0.000010],
            [29339, 0.000010],
            [21299, 0.000010],
            [10068, 0.000010],
            [100527, 0.000010],
            [102628, 0.000010],
            [29337, 0.000010],
            [29366, 0.000010],
            [47119, 0.000010],
            [127, 0.000010],
            [103573, 0.000010],
            [21512, 0.000010],
            [29364, 0.000010],
            [102919, 0.000010],
            [10279, 0.000010],
            [102639, 0.000010],
            [21035, 0.000010],
            [10109, 0.000010],
            [26001, 0.000010],
            [11071, 0.000010],
            [102633, 0.000010],
            [11106, 0.000010],
            [102649, 0.000010],
            [29373, 0.000010],
            [28697, 0.000010],
            [102990, 0.000010],
            [21282, 0.000010],
            [102645, 0.000010],
            [104902, 0.000010],
            [20602, 0.000010],
            [28676, 0.000010],
            [10777, 0.000010],
            [103751, 0.000010],
            [10633, 0.000010],
            [11227, 0.000010],
            [104139, 0.000010],
            [101062, 0.000010],
            [104137, 0.000010],
            [10429, 0.000010],
            [29352, 0.000010],
            [103581, 0.000010],
            [10255, 0.000009],
            [11086, 0.000009],
            [102623, 0.000009],
            [11151, 0.000009],
            [102619, 0.000009],
            [102773, 0.000009],
            [21630, 0.000009],
            [10769, 0.000009],
            [27585, 0.000009],
            [20958, 0.000009],
            [20197, 0.000009],
            [29226, 0.000009],
            [29357, 0.000009],
            [11446, 0.000009],
            [10520, 0.000009],
            [10490, 0.000009],
            [102739, 0.000009],
            [11152, 0.000009],
            [28944, 0.000009],
            [98532, 0.000009],
            [104794, 0.000009],
            [10681, 0.000009],
            [10054, 0.000009],
            [100661, 0.000009],
            [21403, 0.000009],
            [20902, 0.000009],
            [100471, 0.000009],
            [21164, 0.000009],
            [29338, 0.000009],
            [102617, 0.000009],
            [99634, 0.000009],
            [103578, 0.000009],
            [102681, 0.000009],
            [103749, 0.000009],
            [102875, 0.000009],
            [20981, 0.000009],
            [10510, 0.000008],
            [29359, 0.000008],
            [102634, 0.000008],
            [102686, 0.000008],
            [20835, 0.000008],
            [10015, 0.000008],
            [20624, 0.000008],
            [27510, 0.000008],
            [102641, 0.000008],
            [20032, 0.000008],
            [104916, 0.000008],
            [20968, 0.000008],
            [102644, 0.000008],
            [20758, 0.000008],
            [102621, 0.000008],
            [29324, 0.000008],
            [27026, 0.000008],
            [21366, 0.000008],
            [104836, 0.000008],
            [21473, 0.000008],
            [10902, 0.000008],
            [10105, 0.000008],
            [101463, 0.000008],
            [10782, 0.000008],
            [103754, 0.000008],
            [100480, 0.000008],
            [103810, 0.000008],
            [27433, 0.000008],
            [27669, 0.000008],
            [29637, 0.000008],
            [102914, 0.000008],
            [29145, 0.000008],
            [21341, 0.000008],
            [29336, 0.000008],
            [102694, 0.000008],
            [24888, 0.000008],
            [27924, 0.000008],
            [104801, 0.000008],
            [21207, 0.000008],
            [21163, 0.000008],
            [20574, 0.000008],
            [27851, 0.000008],
            [10330, 0.000008],
            [102627, 0.000008],
            [102669, 0.000008],
            [11435, 0.000008],
            [102884, 0.000008],
            [29590, 0.000008],
            [21183, 0.000008],
            [10715, 0.000008],
            [11487, 0.000008],
            [102527, 0.000008],
            [20546, 0.000008],
            [10596, 0.000008],
            [21205, 0.000008],
            [21248, 0.000008],
            [101677, 0.000008],
            [104864, 0.000008],
            [102643, 0.000008],
            [29643, 0.000008],
            [101060, 0.000008],
            [104104, 0.000008],
            [102626, 0.000007],
            [21703, 0.000007],
            [102957, 0.000007],
            [28940, 0.000007],
            [11068, 0.000007],
            [20160, 0.000007],
            [102589, 0.000007],
            [102833, 0.000007],
            [10138, 0.000007],
            [11246, 0.000007],
            [11283, 0.000007],
            [103795, 0.000007],
            [102608, 0.000007],
            [20978, 0.000007],
            [11179, 0.000007],
            [101680, 0.000007],
            [102698, 0.000007],
            [103593, 0.000007],
            [102718, 0.000007],
            [10929, 0.000007],
            [11117, 0.000007],
            [100529, 0.000007],
            [102642, 0.000007],
            [103000, 0.000007],
            [10101, 0.000007],
            [21223, 0.000007],
            [10996, 0.000007],
            [10336, 0.000007],
            [102756, 0.000007],
            [11149, 0.000007],
            [101644, 0.000007],
            [10329, 0.000007],
            [102652, 0.000007],
            [10488, 0.000007],
            [104822, 0.000007],
            [28668, 0.000007],
            [20545, 0.000007],
            [10388, 0.000007],
            [102867, 0.000007],
            [102772, 0.000007],
            [10889, 0.000007],
            [102763, 0.000007],
            [10876, 0.000007],
            [102636, 0.000007],
            [10622, 0.000007],
            [102632, 0.000007],
            [103570, 0.000007],
            [20845, 0.000007],
            [29331, 0.000007],
            [104102, 0.000007],
            [27670, 0.000007],
            [29365, 0.000007],
            [21654, 0.000007],
            [10733, 0.000007],
            [21393, 0.000007],
            [10703, 0.000007],
            [102624, 0.000007],
            [10538, 0.000007],
            [102815, 0.000006],
            [11242, 0.000006],
            [102600, 0.000006],
            [103098, 0.000006],
            [21180, 0.000006],
            [20092, 0.000006],
            [20966, 0.000006],
            [101454, 0.000006],
            [11452, 0.000006],
            [101738, 0.000006],
            [27917, 0.000006],
            [103574, 0.000006],
            [102743, 0.000006],
            [102685, 0.000006],
            [100999, 0.000006],
            [104868, 0.000006],
            [29334, 0.000006],
            [104908, 0.000006],
            [29368, 0.000006],
            [20742, 0.000006],
            [102668, 0.000006],
            [27189, 0.000006],
            [11417, 0.000006],
            [20052, 0.000006],
            [11169, 0.000006],
            [10775, 0.000006],
            [11054, 0.000006],
            [10837, 0.000006],
            [29645, 0.000006],
            [102663, 0.000006],
            [11513, 0.000006],
            [104870, 0.000006],
            [10456, 0.000006],
            [71203, 0.000006],
            [20857, 0.000006],
            [104181, 0.000006],
            [103588, 0.000006],
            [139, 0.000006],
            [102651, 0.000006],
            [28809, 0.000006],
            [100944, 0.000006],
            [21110, 0.000006],
            [11355, 0.000006],
            [20704, 0.000006],
            [11030, 0.000006],
            [104562, 0.000006],
            [27536, 0.000006],
            [10843, 0.000006],
            [10508, 0.000006],
            [10700, 0.000006],
            [102735, 0.000006],
            [103266, 0.000006],
            [102689, 0.000006],
            [103572, 0.000006],
            [21077, 0.000006],
            [104103, 0.000006],
            [104883, 0.000006],
            [102844, 0.000006],
            [28805, 0.000006],
            [27302, 0.000006],
            [102590, 0.000006],
            [11498, 0.000006],
            [11233, 0.000006],
            [102723, 0.000006],
            [102620, 0.000006],
            [11021, 0.000006],
            [102640, 0.000006],
            [11401, 0.000006],
            [30822, 0.000006],
            [11243, 0.000006],
            [103031, 0.000006],
            [102713, 0.000006],
            [104809, 0.000005],
            [10392, 0.000005],
            [29639, 0.000005],
            [101657, 0.000005],
            [21466, 0.000005],
            [10476, 0.000005],
            [10589, 0.000005],
            [103580, 0.000005],
            [102703, 0.000005],
            [103355, 0.000005],
            [210, 0.000005],
            [102714, 0.000005],
            [27217, 0.000005],
            [29333, 0.000005],
            [20965, 0.000005],
            [10594, 0.000005],
            [21613, 0.000005],
            [102697, 0.000005],
            [104824, 0.000005],
            [10458, 0.000005],
            [11315, 0.000005],
            [101407, 0.000005],
            [21382, 0.000005],
            [10931, 0.000005],
            [102817, 0.000005],
            [102786, 0.000005],
            [104857, 0.000005],
            [21105, 0.000005],
            [101445, 0.000005],
            [102896, 0.000005],
            [102610, 0.000005],
            [20275, 0.000005],
            [103602, 0.000005],
            [11396, 0.000005],
            [41195, 0.000005],
            [102695, 0.000005],
            [37156, 0.000005],
            [103755, 0.000005],
            [20178, 0.000005],
            [101531, 0.000005],
            [102832, 0.000005],
            [20547, 0.000005],
            [20773, 0.000005],
            [21544, 0.000005],
            [101506, 0.000005],
            [102897, 0.000005],
            [10973, 0.000005],
            [20584, 0.000005],
            [102674, 0.000005],
            [103239, 0.000005],
            [21063, 0.000005],
            [102778, 0.000005],
            [27532, 0.000005],
            [102753, 0.000005],
            [11344, 0.000005],
            [102749, 0.000005],
            [104911, 0.000005],
            [20096, 0.000005],
            [103592, 0.000005],
            [11368, 0.000005],
            [21364, 0.000005],
            [102708, 0.000005],
            [28578, 0.000005],
            [103548, 0.000005],
            [27932, 0.000005],
            [100531, 0.000005],
            [20239, 0.000005],
            [104606, 0.000005],
            [102758, 0.000005],
            [21006, 0.000005],
            [27671, 0.000005],
            [101530, 0.000005],
            [102662, 0.000005],
            [11031, 0.000005],
            [29288, 0.000005],
            [10615, 0.000005],
            [101593, 0.000005],
            [102650, 0.000005],
            [10083, 0.000005],
            [21285, 0.000005],
            [11236, 0.000005],
            [103241, 0.000005],
            [20577, 0.000005],
            [102736, 0.000005],
            [20991, 0.000005],
            [102667, 0.000005],
            [20041, 0.000005],
            [102762, 0.000005],
            [103579, 0.000005],
            [103586, 0.000005],
            [29346, 0.000005],
            [104818, 0.000005],
            [21090, 0.000005],
            [102943, 0.000005],
            [71869, 0.000005],
            [20830, 0.000005],
            [10090, 0.000005],
            [102795, 0.000005],
            [40419, 0.000005],
            [11144, 0.000005],
            [102913, 0.000005],
            [100914, 0.000005],
            [11510, 0.000005],
            [102581, 0.000005],
            [28533, 0.000005],
            [102710, 0.000005],
            [100951, 0.000005],
            [10459, 0.000005],
            [102637, 0.000005],
            [21390, 0.000005],
            [10603, 0.000005],
            [104830, 0.000005],
            [104106, 0.000004],
            [103406, 0.000004],
            [102877, 0.000004],
            [35393, 0.000004],
            [10395, 0.000004],
            [20548, 0.000004],
            [20747, 0.000004],
            [10337, 0.000004],
            [21389, 0.000004],
            [10440, 0.000004],
            [24874, 0.000004],
            [11173, 0.000004],
            [103809, 0.000004],
            [28772, 0.000004],
            [102659, 0.000004],
            [21477, 0.000004],
            [102748, 0.000004],
            [10465, 0.000004],
            [102712, 0.000004],
            [10424, 0.000004],
            [101532, 0.000004],
            [29392, 0.000004],
            [104796, 0.000004],
            [103808, 0.000004],
            [11448, 0.000004],
            [102742, 0.000004],
            [101393, 0.000004],
            [102781, 0.000004],
            [20715, 0.000004],
            [104152, 0.000004],
            [103604, 0.000004],
            [102999, 0.000004],
            [20896, 0.000004],
            [21170, 0.000004],
            [102726, 0.000004],
            [10452, 0.000004],
            [103833, 0.000004],
            [20610, 0.000004],
            [20956, 0.000004],
            [21242, 0.000004],
            [29647, 0.000004],
            [102664, 0.000004],
            [102671, 0.000004],
            [21608, 0.000004],
            [102647, 0.000004],
            [10644, 0.000004],
            [102854, 0.000004],
            [10437, 0.000004],
            [21323, 0.000004],
            [101513, 0.000004],
            [102660, 0.000004],
            [21344, 0.000004],
            [104567, 0.000004],
            [20933, 0.000004],
            [20920, 0.000004],
            [102754, 0.000004],
            [21646, 0.000004],
            [104850, 0.000004],
            [102724, 0.000004],
            [28590, 0.000004],
            [104191, 0.000004],
            [104813, 0.000004],
            [102720, 0.000004],
            [102885, 0.000004],
            [11085, 0.000004],
            [10283, 0.000004],
            [102779, 0.000004],
            [27286, 0.000004],
            [101056, 0.000004],
            [102646, 0.000004],
            [103557, 0.000004],
            [10063, 0.000004],
            [103032, 0.000004],
            [101497, 0.000004],
            [102858, 0.000004],
            [102683, 0.000004],
            [101760, 0.000004],
            [102800, 0.000004],
            [104786, 0.000004],
            [10992, 0.000004],
            [11023, 0.000004],
            [104164, 0.000004],
            [21411, 0.000004],
            [102874, 0.000004],
            [20680, 0.000004],
            [29320, 0.000004],
            [101759, 0.000004],
            [104790, 0.000004],
            [10389, 0.000004],
            [101273, 0.000004],
            [104839, 0.000004],
            [21098, 0.000004],
            [21414, 0.000004],
            [20992, 0.000004],
            [20856, 0.000004],
            [102888, 0.000004],
            [20939, 0.000004],
            [102768, 0.000004],
            [20089, 0.000004],
            [102842, 0.000004],
            [101795, 0.000004],
            [27828, 0.000004],
            [102673, 0.000004],
            [21767, 0.000004],
            [21231, 0.000004],
            [11182, 0.000004],
            [103365, 0.000003],
            [103590, 0.000003],
            [104179, 0.000003],
            [103068, 0.000003],
            [20736, 0.000003],
            [101490, 0.000003],
            [21468, 0.000003],
            [101846, 0.000003],
            [102801, 0.000003],
            [10785, 0.000003],
            [95, 0.000003],
            [10779, 0.000003],
            [27805, 0.000003],
            [10553, 0.000003],
            [11270, 0.000003],
            [10535, 0.000003],
            [10427, 0.000003],
            [103243, 0.000003],
            [102701, 0.000003],
            [102706, 0.000003],
            [102678, 0.000003],
            [102665, 0.000003],
            [100858, 0.000003],
            [102935, 0.000003],
            [102994, 0.000003],
            [102826, 0.000003],
            [20637, 0.000003],
            [104917, 0.000003],
            [102814, 0.000003],
            [10616, 0.000003],
            [102898, 0.000003],
            [103556, 0.000003],
            [11180, 0.000003],
            [100546, 0.000003],
            [102879, 0.000003],
            [21168, 0.000003],
            [102809, 0.000003],
            [103844, 0.000003],
            [11126, 0.000003],
            [103826, 0.000003],
            [103614, 0.000003],
            [103164, 0.000003],
            [103589, 0.000003],
            [20975, 0.000003],
            [11407, 0.000003],
            [103007, 0.000003],
            [11224, 0.000003],
            [102978, 0.000003],
            [29328, 0.000003],
            [103617, 0.000003],
            [102745, 0.000003],
            [104854, 0.000003],
            [104550, 0.000003],
            [102837, 0.000003],
            [29318, 0.000003],
            [21378, 0.000003],
            [10988, 0.000003],
            [103383, 0.000003],
            [102654, 0.000003],
            [29128, 0.000003],
            [10814, 0.000003],
            [20655, 0.000003],
            [21171, 0.000003],
            [29354, 0.000003],
            [10636, 0.000003],
            [104887, 0.000003],
            [11449, 0.000003],
            [102690, 0.000003],
            [10513, 0.000003],
            [10397, 0.000003],
            [21162, 0.000003],
            [102827, 0.000003],
            [20777, 0.000003],
            [102612, 0.000003],
            [21175, 0.000003],
            [10697, 0.000003],
            [103471, 0.000003],
            [102774, 0.000003],
            [102948, 0.000003],
            [103829, 0.000003],
            [20875, 0.000003],
            [102725, 0.000003],
            [104381, 0.000003],
            [104892, 0.000003],
            [28559, 0.000003],
            [20600, 0.000003],
            [29358, 0.000003],
            [101754, 0.000003],
            [103121, 0.000003],
            [28344, 0.000003],
            [21004, 0.000003],
            [104898, 0.000003],
            [103135, 0.000003],
            [102967, 0.000003],
            [97229, 0.000003],
            [87, 0.000003],
            [27473, 0.000003],
            [27699, 0.000003],
            [10637, 0.000003],
            [103070, 0.000003],
            [103037, 0.000003],
            [29344, 0.000003],
            [10254, 0.000003],
            [102751, 0.000003],
            [21699, 0.000003],
            [102805, 0.000003],
            [10934, 0.000003],
            [102863, 0.000003],
            [103016, 0.000003],
            [104851, 0.000003],
            [21193, 0.000003],
            [71620, 0.000003],
            [104816, 0.000003],
            [29356, 0.000003],
            [102784, 0.000003],
            [29329, 0.000003],
            [29036, 0.000003],
            [103246, 0.000003],
            [20925, 0.000003],
            [101411, 0.000003],
            [103616, 0.000003],
            [104873, 0.000003],
            [103115, 0.000003],
            [102932, 0.000003],
            [27989, 0.000003],
            [21763, 0.000003],
            [21244, 0.000003],
            [21104, 0.000003],
            [103223, 0.000003],
            [102894, 0.000003],
            [101318, 0.000003],
            [101263, 0.000003],
            [102767, 0.000003],
            [20935, 0.000003],
            [20961, 0.000003],
            [101578, 0.000003],
            [103369, 0.000003],
            [27520, 0.000003],
            [102799, 0.000003],
            [103598, 0.000003],
            [29341, 0.000003],
            [20843, 0.000003],
            [102928, 0.000003],
            [104921, 0.000003],
            [102900, 0.000003],
            [11219, 0.000003],
            [102791, 0.000003],
            [104838, 0.000003],
            [101391, 0.000003],
            [10613, 0.000003],
            [10257, 0.000003],
            [102955, 0.000003],
            [11399, 0.000003],
            [102747, 0.000003],
            [104798, 0.000003],
            [102859, 0.000003],
            [102693, 0.000003],
            [21182, 0.000003],
            [10119, 0.000003],
            [29321, 0.000003],
            [104919, 0.000003],
            [20831, 0.000003],
            [10147, 0.000003],
            [103620, 0.000003],
            [21316, 0.000003],
            [102670, 0.000003],
            [20084, 0.000003],
            [102702, 0.000003],
            [10581, 0.000003],
            [103577, 0.000003],
            [104600, 0.000003],
            [6120, 0.000003],
            [27584, 0.000002],
            [102944, 0.000002],
            [102738, 0.000002],
            [104910, 0.000002],
            [102988, 0.000002],
            [29641, 0.000002],
            [103104, 0.000002],
            [20944, 0.000002],
            [21394, 0.000002],
            [102787, 0.000002],
            [37792, 0.000002],
            [89, 0.000002],
            [21538, 0.000002],
            [103029, 0.000002],
            [27639, 0.000002],
            [21144, 0.000002],
            [101487, 0.000002],
            [103172, 0.000002],
            [10530, 0.000002],
            [103632, 0.000002],
            [21486, 0.000002],
            [21210, 0.000002],
            [11203, 0.000002],
            [103358, 0.000002],
            [101446, 0.000002],
            [102759, 0.000002],
            [10571, 0.000002],
            [28186, 0.000002],
            [103619, 0.000002],
            [100492, 0.000002],
            [102648, 0.000002],
            [104607, 0.000002],
            [102831, 0.000002],
            [104404, 0.000002],
            [11454, 0.000002],
            [21591, 0.000002],
            [101421, 0.000002],
            [21074, 0.000002],
            [102561, 0.000002],
            [10524, 0.000002],
            [20771, 0.000002],
            [103054, 0.000002],
            [21570, 0.000002],
            [103600, 0.000002],
            [10526, 0.000002],
            [103129, 0.000002],
            [101479, 0.000002],
            [27186, 0.000002],
            [102716, 0.000002],
            [102901, 0.000002],
            [103012, 0.000002],
            [102819, 0.000002],
            [102961, 0.000002],
            [103085, 0.000002],
            [102985, 0.000002],
            [104820, 0.000002],
            [103046, 0.000002],
            [27608, 0.000002],
            [10451, 0.000002],
            [102679, 0.000002],
            [21453, 0.000002],
            [103594, 0.000002],
            [21080, 0.000002],
            [103761, 0.000002],
            [103089, 0.000002],
            [10572, 0.000002],
            [103584, 0.000002],
            [29348, 0.000002],
            [102630, 0.000002],
            [102882, 0.000002],
            [102771, 0.000002],
            [11431, 0.000002],
            [103249, 0.000002],
            [11260, 0.000002],
            [20960, 0.000002],
            [102765, 0.000002],
            [20854, 0.000002],
            [21728, 0.000002],
            [102843, 0.000002],
            [27441, 0.000002],
            [103145, 0.000002],
            [104872, 0.000002],
            [102860, 0.000002],
            [102722, 0.000002],
            [102715, 0.000002],
            [104826, 0.000002],
            [21062, 0.000002],
            [11317, 0.000002],
            [102883, 0.000002],
            [102709, 0.000002],
            [103194, 0.000002],
            [24878, 0.000002],
            [102677, 0.000002],
            [29369, 0.000002],
            [103205, 0.000002],
            [102658, 0.000002],
            [29332, 0.000002],
            [21636, 0.000002],
            [102821, 0.000002],
            [21235, 0.000002],
            [100188, 0.000002],
            [20931, 0.000002],
            [100482, 0.000002],
            [11018, 0.000002],
            [102966, 0.000002],
            [103301, 0.000002],
            [104849, 0.000002],
            [103294, 0.000002],
            [11389, 0.000002],
            [104913, 0.000002],
            [20786, 0.000002],
            [103297, 0.000002],
            [103639, 0.000002],
            [27925, 0.000002],
            [21230, 0.000002],
            [102828, 0.000002],
            [103067, 0.000002],
            [11412, 0.000002],
            [104803, 0.000002],
            [29335, 0.000002],
            [102824, 0.000002],
            [102841, 0.000002],
            [102839, 0.000002],
            [101444, 0.000002],
            [102790, 0.000002],
            [20241, 0.000002],
            [21178, 0.000002],
            [102965, 0.000002],
            [104244, 0.000002],
            [102764, 0.000002],
            [102852, 0.000002],
            [29370, 0.000002],
            [10140, 0.000002],
            [21320, 0.000002],
            [21553, 0.000002],
            [102958, 0.000002],
            [104888, 0.000002],
            [103173, 0.000002],
            [20593, 0.000002],
            [103831, 0.000002],
            [102862, 0.000002],
            [103270, 0.000002],
            [10430, 0.000002],
            [102907, 0.000002],
            [104859, 0.000002],
            [27561, 0.000002],
            [27655, 0.000002],
            [24886, 0.000002],
            [29343, 0.000002],
            [102845, 0.000002],
            [102675, 0.000002],
            [10098, 0.000002],
            [103836, 0.000002],
            [103022, 0.000002],
            [10017, 0.000002],
            [102807, 0.000002],
            [103537, 0.000002],
            [102945, 0.000002],
            [100517, 0.000002],
            [11128, 0.000002],
            [103351, 0.000002],
            [20885, 0.000002],
            [21092, 0.000002],
            [11120, 0.000002],
            [102869, 0.000002],
            [10276, 0.000002],
            [170, 0.000002],
            [103443, 0.000002],
            [102993, 0.000002],
            [104811, 0.000002],
            [21464, 0.000002],
            [103103, 0.000002],
            [20828, 0.000002],
            [102835, 0.000002],
            [102611, 0.000002],
            [104829, 0.000002],
            [102792, 0.000002],
            [102910, 0.000002],
            [103382, 0.000002],
            [101646, 0.000002],
            [11026, 0.000002],
            [104877, 0.000002],
            [103340, 0.000002],
            [104853, 0.000002],
            [29351, 0.000002],
            [102793, 0.000002],
            [20128, 0.000002],
            [21239, 0.000002],
            [104827, 0.000002],
            [10898, 0.000002],
            [27085, 0.000002],
            [102840, 0.000002],
            [102785, 0.000002],
            [103835, 0.000002],
            [104419, 0.000002],
            [20272, 0.000002],
            [21146, 0.000002],
            [100524, 0.000002],
            [102760, 0.000002],
            [10375, 0.000002],
            [102810, 0.000002],
            [27394, 0.000002],
            [103118, 0.000002],
            [103350, 0.000002],
            [101632, 0.000002],
            [102865, 0.000002],
            [103190, 0.000002],
            [10729, 0.000002],
            [29636, 0.000002],
            [21665, 0.000002],
            [100518, 0.000002],
            [103065, 0.000002],
            [101315, 0.000002],
            [104915, 0.000002],
            [104159, 0.000002],
            [13457, 0.000002],
            [20778, 0.000002],
            [102923, 0.000002],
            [11019, 0.000002],
            [11392, 0.000002],
            [104311, 0.000002],
            [102575, 0.000002],
            [28240, 0.000002],
            [103208, 0.000002],
            [104922, 0.000002],
            [10712, 0.000002],
            [102783, 0.000002],
            [103368, 0.000002],
            [10139, 0.000002],
            [103092, 0.000002],
            [102661, 0.000002],
            [10417, 0.000002],
            [103608, 0.000002],
            [103165, 0.000002],
            [103451, 0.000002],
            [103020, 0.000002],
            [104107, 0.000002],
            [21312, 0.000002],
            [104814, 0.000002],
            [103125, 0.000002],
            [21361, 0.000002],
            [21137, 0.000002],
            [11424, 0.000002],
            [102969, 0.000002],
            [104627, 0.000002],
            [29323, 0.000002],
            [104788, 0.000002],
            [21225, 0.000002],
            [102766, 0.000002],
            [103595, 0.000002],
            [13455, 0.000002],
            [103606, 0.000002],
            [13461, 0.000002],
            [103163, 0.000002],
            [102856, 0.000002],
            [104905, 0.000002],
            [104785, 0.000002],
            [20193, 0.000002],
            [101517, 0.000002],
            [100543, 0.000002],
            [103282, 0.000002],
            [20999, 0.000002],
            [104856, 0.000002],
            [103830, 0.000002],
            [102680, 0.000002],
            [103242, 0.000002],
            [102746, 0.000002],
            [102972, 0.000002],
            [103837, 0.000002],
            [103607, 0.000001],
            [103603, 0.000001],
            [103237, 0.000001],
            [24892, 0.000001],
            [101489, 0.000001],
            [10893, 0.000001],
            [104861, 0.000001],
            [104841, 0.000001],
            [101685, 0.000001],
            [21449, 0.000001],
            [103130, 0.000001],
            [26550, 0.000001],
            [102705, 0.000001],
            [10515, 0.000001],
            [102904, 0.000001],
            [102704, 0.000001],
            [29512, 0.000001],
            [103463, 0.000001],
            [103335, 0.000001],
            [27894, 0.000001],
            [104546, 0.000001],
            [10142, 0.000001],
            [102982, 0.000001],
            [103513, 0.000001],
            [29325, 0.000001],
            [20812, 0.000001],
            [10441, 0.000001],
            [100033, 0.000001],
            [102822, 0.000001],
            [10718, 0.000001],
            [10331, 0.000001],
            [102657, 0.000001],
            [10464, 0.000001],
            [20174, 0.000001],
            [103296, 0.000001],
            [102954, 0.000001],
            [103488, 0.000001],
            [10370, 0.000001],
            [10312, 0.000001],
            [102691, 0.000001],
            [104486, 0.000001],
            [29471, 0.000001],
            [104302, 0.000001],
            [10751, 0.000001],
            [102871, 0.000001],
            [20803, 0.000001],
            [104624, 0.000001],
            [103599, 0.000001],
            [104491, 0.000001],
            [103610, 0.000001],
            [29362, 0.000001],
            [10428, 0.000001],
            [28999, 0.000001],
            [27542, 0.000001],
            [103151, 0.000001],
            [103758, 0.000001],
            [21052, 0.000001],
            [103834, 0.000001],
            [103036, 0.000001],
            [102980, 0.000001],
            [101410, 0.000001],
            [102737, 0.000001],
            [21120, 0.000001],
            [28429, 0.000001],
            [103504, 0.000001],
            [103628, 0.000001],
            [10967, 0.000001],
            [10525, 0.000001],
            [102930, 0.000001],
            [102916, 0.000001],
            [102728, 0.000001],
            [103265, 0.000001],
            [101021, 0.000001],
            [21197, 0.000001],
            [103218, 0.000001],
            [10972, 0.000001],
            [104823, 0.000001],
            [102699, 0.000001],
            [103069, 0.000001],
            [103269, 0.000001],
            [103005, 0.000001],
            [20165, 0.000001],
            [103762, 0.000001],
            [102804, 0.000001],
            [103010, 0.000001],
            [102939, 0.000001],
            [21091, 0.000001],
            [20936, 0.000001],
            [28810, 0.000001],
            [102587, 0.000001],
            [10251, 0.000001],
            [103333, 0.000001],
            [102717, 0.000001],
            [21198, 0.000001],
            [103525, 0.000001],
            [102813, 0.000001],
            [29054, 0.000001],
            [20955, 0.000001],
            [11400, 0.000001],
            [29367, 0.000001],
            [103343, 0.000001],
            [21529, 0.000001],
            [41030, 0.000001],
            [21115, 0.000001],
            [104464, 0.000001],
            [103360, 0.000001],
            [26929, 0.000001],
            [102864, 0.000001],
            [102761, 0.000001],
            [21042, 0.000001],
            [102789, 0.000001],
            [103438, 0.000001],
            [103015, 0.000001],
            [102963, 0.000001],
            [104889, 0.000001],
            [103601, 0.000001],
            [29319, 0.000001],
            [104431, 0.000001],
            [103234, 0.000001],
            [102899, 0.000001],
            [102996, 0.000001],
            [104409, 0.000001],
            [103245, 0.000001],
            [10744, 0.000001],
            [103634, 0.000001],
            [103753, 0.000001],
            [104844, 0.000001],
            [102777, 0.000001],
            [96947, 0.000001],
            [103096, 0.000001],
            [21349, 0.000001],
            [27018, 0.000001],
            [10521, 0.000001],
            [103011, 0.000001],
            [103842, 0.000001],
            [103184, 0.000001],
            [103087, 0.000001],
            [102850, 0.000001],
            [102933, 0.000001],
            [102732, 0.000001],
            [103353, 0.000001],
            [102808, 0.000001],
            [20796, 0.000001],
            [102940, 0.000001],
            [3958, 0.000001],
            [104819, 0.000001],
            [20954, 0.000001],
            [103051, 0.000001],
            [102925, 0.000001],
            [103465, 0.000001],
            [102895, 0.000001],
            [103001, 0.000001],
            [10373, 0.000001],
            [207, 0.000001],
            [104893, 0.000001],
            [100505, 0.000001],
            [20625, 0.000001],
            [103609, 0.000001],
            [104855, 0.000001],
            [28257, 0.000001],
            [29519, 0.000001],
            [10280, 0.000001],
            [10732, 0.000001],
            [103457, 0.000001],
            [104865, 0.000001],
            [102825, 0.000001],
            [28355, 0.000001],
            [103627, 0.000001],
            [20895, 0.000001],
            [102971, 0.000001],
            [102912, 0.000001],
            [102853, 0.000001],
            [102776, 0.000001],
            [103342, 0.000001],
            [10757, 0.000001],
            [20980, 0.000001],
            [100613, 0.000001],
            [21618, 0.000001],
            [103174, 0.000001],
            [102846, 0.000001],
            [21033, 0.000001],
            [10438, 0.000001],
            [20993, 0.000001],
            [102794, 0.000001],
            [103014, 0.000001],
            [10773, 0.000001],
            [103618, 0.000001],
            [103381, 0.000001],
            [104821, 0.000001],
            [102903, 0.000001],
            [103630, 0.000001],
            [103207, 0.000001],
            [21480, 0.000001],
            [103845, 0.000001],
            [10956, 0.000001],
            [21697, 0.000001],
            [103017, 0.000001],
            [21174, 0.000001],
            [29415, 0.000001],
            [101849, 0.000001],
            [102836, 0.000001],
            [101471, 0.000001],
            [27139, 0.000001],
            [103161, 0.000001],
            [102812, 0.000001],
            [29412, 0.000001],
            [102921, 0.000001],
            [103033, 0.000001],
            [103512, 0.000001],
            [103583, 0.000001],
            [28786, 0.000001],
            [28784, 0.000001],
            [103519, 0.000001],
            [102929, 0.000001],
            [103076, 0.000001],
            [20691, 0.000001],
            [102997, 0.000001],
            [102861, 0.000001],
            [10868, 0.000001],
            [29454, 0.000001],
            [102788, 0.000001],
            [10870, 0.000001],
            [103468, 0.000001],
            [21280, 0.000001],
            [11200, 0.000001],
            [104901, 0.000001],
            [100734, 0.000001],
            [44434, 0.000001],
            [37159, 0.000001],
            [101415, 0.000001],
            [103077, 0.000001],
            [104885, 0.000001],
            [103283, 0.000001],
            [21569, 0.000001],
            [103131, 0.000001],
            [27764, 0.000001],
            [103482, 0.000001],
            [20763, 0.000001],
            [21010, 0.000001],
            [101271, 0.000001],
            [102974, 0.000001],
            [23329, 0.000001],
            [103047, 0.000001],
            [103225, 0.000001],
            [103289, 0.000001],
            [104316, 0.000001],
            [104301, 0.000001],
            [104845, 0.000001],
            [21185, 0.000001],
            [103220, 0.000001],
            [104843, 0.000001],
            [10807, 0.000001],
            [11459, 0.000001],
            [102857, 0.000001],
            [103238, 0.000001],
            [102818, 0.000001],
            [102906, 0.000001],
            [10518, 0.000001],
            [26735, 0.000001],
            [103088, 0.000001],
            [103310, 0.000001],
            [101748, 0.000001],
            [21172, 0.000001],
            [10260, 0.000001],
            [103444, 0.000001],
            [103626, 0.000001],
            [28382, 0.000001],
            [103397, 0.000001],
            [104880, 0.000001],
            [103411, 0.000001],
            [102917, 0.000001],
            [102733, 0.000001],
            [10612, 0.000001],
            [10479, 0.000001],
            [102915, 0.000001],
            [103481, 0.000001],
            [104886, 0.000001],
            [103183, 0.000001],
            [103086, 0.000001],
            [101541, 0.000001],
            [102995, 0.000001],
            [101774, 0.000001],
            [102956, 0.000001],
            [100911, 0.000001],
            [103170, 0.000001],
            [20073, 0.000001],
            [21536, 0.000001],
            [103401, 0.000001],
            [103418, 0.000001],
            [103861, 0.000001],
            [101416, 0.000001],
            [11429, 0.000001],
            [103187, 0.000001],
            [21338, 0.000001],
            [103250, 0.000001],
            [103288, 0.000001],
            [21606, 0.000001],
            [104881, 0.000001],
            [103002, 0.000001],
            [103150, 0.000001],
            [102823, 0.000001],
            [102891, 0.000001],
            [10022, 0.000001],
            [21564, 0.000001],
            [104879, 0.000001],
            [104799, 0.000001],
            [102941, 0.000001],
            [103637, 0.000001],
            [103597, 0.000001],
            [103153, 0.000001],
            [104833, 0.000001],
            [102962, 0.000001],
            [103148, 0.000001],
            [27126, 0.000001],
            [103539, 0.000001],
            [102797, 0.000001],
            [103461, 0.000001],
            [102721, 0.000001],
            [103257, 0.000001],
            [21326, 0.000001],
            [21666, 0.000001],
            [103615, 0.000001],
            [104804, 0.000001],
            [102730, 0.000001],
            [103473, 0.000001],
            [29520, 0.000001],
            [103215, 0.000001],
            [104795, 0.000001],
            [102834, 0.000001],
            [102731, 0.000001],
            [26923, 0.000001],
            [103141, 0.000001],
            [29408, 0.000001],
            [20945, 0.000001],
            [21217, 0.000001],
            [10961, 0.000001],
            [103008, 0.000001],
            [103472, 0.000001],
            [104899, 0.000001],
            [102934, 0.000001],
            [103641, 0.000001],
            [21426, 0.000001],
            [21321, 0.000001],
            [21113, 0.000001],
            [101353, 0.000001],
            [103127, 0.000001],
            [103329, 0.000001],
            [103642, 0.000001],
            [103331, 0.000001],
            [103221, 0.000001],
            [103646, 0.000001],
            [29552, 0.000001],
            [103108, 0.000001],
            [104805, 0.000001],
            [102947, 0.000001],
            [104635, 0.000001],
            [102986, 0.000001],
            [103140, 0.000001],
            [26349, 0.000001],
            [102872, 0.000001],
            [103081, 0.000001],
            [10981, 0.000001],
            [103531, 0.000001],
            [102562, 0.000001],
            [10263, 0.000001],
            [102959, 0.000001],
            [101314, 0.000001],
            [21319, 0.000001],
            [11272, 0.000001],
            [103487, 0.000001],
            [102920, 0.000001],
            [27211, 0.000001],
            [20844, 0.000001],
            [104862, 0.000001],
            [103824, 0.000001],
            [104791, 0.000001],
            [46740, 0.000001],
            [21151, 0.000001],
            [102744, 0.000001],
            [26010, 0.000001],
            [101595, 0.000001],
            [10577, 0.000001],
            [21267, 0.000001],
            [29002, 0.000001],
            [103038, 0.000001],
            [37181, 0.000001],
            [102984, 0.000001],
            [103376, 0.000001],
            [21157, 0.000001],
            [21208, 0.000001],
            [104626, 0.000001],
            [103061, 0.000001],
            [102905, 0.000001],
            [103214, 0.000001],
            [102740, 0.000001],
            [103260, 0.000001],
            [102796, 0.000001],
            [104793, 0.000001],
            [21048, 0.000001],
            [102946, 0.000001],
            [103056, 0.000001],
            [10284, 0.000001],
            [104847, 0.000001],
            [104863, 0.000001],
            [103838, 0.000001],
            [103648, 0.000001],
            [102981, 0.000001],
            [103006, 0.000001],
            [103049, 0.000001],
            [103613, 0.000001],
            [20643, 0.000001],
            [11444, 0.000001],
            [103412, 0.000001],
            [28658, 0.000001],
            [104128, 0.000001],
            [21085, 0.000001],
            [10990, 0.000001],
            [101277, 0.000001],
            [20149, 0.000001],
            [101278, 0.000001],
            [11483, 0.000001],
            [103261, 0.000001],
            [10261, 0.000001],
            [20873, 0.000001],
            [103210, 0.000001],
            [102855, 0.000001],
            [104882, 0.000001],
            [103501, 0.000001],
            [103391, 0.000001],
            [104808, 0.000001],
            [103635, 0.000001],
            [29345, 0.000001],
            [20037, 0.000001],
            [103247, 0.000001],
            [20869, 0.000001],
            [21546, 0.000001],
            [103449, 0.000001],
            [98621, 0.000001],
            [29115, 0.000001],
            [103529, 0.000001],
            [103030, 0.000001],
            [103338, 0.000001],
            [102798, 0.000001],
            [103209, 0.000001],
            [104907, 0.000001],
            [103278, 0.000001],
            [10412, 0.000001],
            [103231, 0.000001],
            [104792, 0.000001],
            [103138, 0.000001],
            [29406, 0.000001],
            [29476, 0.000001],
            [10958, 0.000001],
            [103653, 0.000001],
            [13458, 0.000001],
            [103229, 0.000001],
            [103500, 0.000001],
            [21424, 0.000001],
            [104797, 0.000001],
            [103152, 0.000001],
            [20799, 0.000001],
            [101643, 0.000001],
            [103414, 0.000001],
            [103154, 0.000001],
            [103093, 0.000001],
            [103155, 0.000001],
            [103079, 0.000001],
            [103110, 0.000001],
            [103035, 0.000001],
            [103413, 0.000001],
            [10275, 0.000001],
            [102866, 0.000001],
            [104852, 0.000001],
            [103497, 0.000001],
            [103193, 0.000001],
            [103066, 0.000001],
            [103102, 0.000001],
            [103305, 0.000001],
            [21461, 0.000001],
            [103522, 0.000001],
            [100540, 0.000001],
            [102989, 0.000001],
            [21045, 0.000001],
            [103536, 0.000001],
            [28340, 0.000001],
            [103258, 0.000001],
            [103169, 0.000001],
            [103850, 0.000001],
            [3964, 0.000001],
            [10907, 0.000001],
            [104912, 0.000001],
            [10872, 0.000001],
            [103299, 0.000001],
            [10150, 0.000001],
            [103378, 0.000001],
            [103188, 0.000001],
            [103147, 0.000001],
            [101466, 0.000001],
            [10133, 0.000001],
            [20059, 0.000001],
            [29436, 0.000001],
            [103082, 0.000001],
            [10912, 0.000001],
            [101476, 0.000001],
            [98554, 0.000001],
            [37168, 0.000001],
            [102848, 0.000001],
            [104802, 0.000001],
            [103107, 0.000001],
            [37129, 0.000001],
            [101453, 0.000001],
            [100953, 0.000001],
            [21566, 0.000001],
            [103202, 0.000001],
            [101691, 0.000001],
            [103370, 0.000001],
            [102931, 0.000001],
            [104867, 0.000001],
            [102889, 0.000001],
            [103421, 0.000001],
            [102992, 0.000001],
            [103217, 0.000001],
            [103143, 0.000001],
            [20729, 0.000001],
            [103226, 0.000001],
            [104337, 0.000001],
            [21764, 0.000001],
            [21495, 0.000001],
            [102811, 0.000001],
            [21518, 0.000001],
            [102770, 0.000001],
            [28447, 0.000001],
            [103013, 0.000001],
            [103366, 0.000001],
            [20749, 0.000001],
            [11110, 0.000001],
            [103034, 0.000001],
            [103377, 0.000001],
            [100754, 0.000001],
            [11460, 0.000001],
            [61994, 0.000001],
            [103116, 0.000001],
            [101484, 0.000001],
            [10706, 0.000001],
            [103402, 0.000001],
            [102937, 0.000001],
            [21075, 0.000001],
            [10100, 0.000001],
            [10497, 0.000001],
            [103185, 0.000001],
            [28503, 0.000001],
            [10768, 0.000001],
            [10310, 0.000001],
            [20732, 0.000001],
            [103346, 0.000001],
            [20838, 0.000001],
            [11398, 0.000001],
            [103308, 0.000001],
            [103314, 0.000001],
            [20661, 0.000001],
            [100547, 0.000001],
            [101599, 0.000001],
            [29508, 0.000001],
            [103090, 0.000001],
            [104840, 0.000001],
            [101538, 0.000001],
            [11113, 0.000001],
            [103651, 0.000001],
            [103387, 0.000001],
            [10936, 0.000001],
            [21498, 0.000001],
            [79004, 0.000001],
            [103410, 0.000001],
            [100949, 0.000001],
            [20850, 0.000001],
            [21638, 0.000001],
            [102851, 0.000001],
            [103025, 0.000001],
            [100818, 0.000001],
            [103026, 0.000001],
            [10640, 0.000001],
            [20665, 0.000001],
            [97237, 0.000001],
            [20872, 0.000001],
            [103591, 0.000001],
            [103432, 0.000001],
            [21143, 0.000001],
            [102953, 0.000001],
            [103385, 0.000001],
            [10607, 0.000001],
            [103018, 0.000001],
            [102892, 0.000001],
            [100983, 0.000001],
            [104336, 0.000001],
            [21016, 0.000001],
            [103095, 0.000001],
            [103053, 0.000001],
            [103469, 0.000001],
            [20646, 0.000001],
            [28891, 0.000001],
            [104622, 0.000001],
            [103175, 0.000001],
            [10462, 0.000001],
            [27496, 0.000001],
            [11015, 0.000001],
            [103027, 0.000001],
            [21438, 0.000001],
            [103654, 0.000001],
            [103275, 0.000001],
            [104605, 0.000001],
            [103157, 0.000001],
            [103097, 0.000001],
            [21377, 0.000001],
            [103345, 0.000001],
            [103106, 0.000001],
            [11405, 0.000001],
            [104817, 0.000001],
            [103408, 0.000001],
            [21005, 0.000000],
            [20595, 0.000000],
            [104488, 0.000000],
            [103158, 0.000000],
            [103197, 0.000000],
            [103045, 0.000000],
            [23341, 0.000000],
            [10957, 0.000000],
            [11234, 0.000000],
            [102782, 0.000000],
            [20259, 0.000000],
            [11123, 0.000000],
            [100548, 0.000000],
            [20899, 0.000000],
            [21362, 0.000000],
            [102838, 0.000000],
            [11033, 0.000000],
            [103363, 0.000000],
            [104223, 0.000000],
            [21064, 0.000000],
            [21307, 0.000000],
            [21258, 0.000000],
            [103470, 0.000000],
            [103429, 0.000000],
            [103273, 0.000000],
            [21655, 0.000000],
            [103304, 0.000000],
            [21563, 0.000000],
            [103647, 0.000000],
            [101413, 0.000000],
            [21169, 0.000000],
            [29644, 0.000000],
            [102973, 0.000000],
            [103629, 0.000000],
            [100506, 0.000000],
            [101545, 0.000000],
            [21232, 0.000000],
            [103364, 0.000000],
            [103060, 0.000000],
            [103415, 0.000000],
            [103072, 0.000000],
            [20827, 0.000000],
            [101770, 0.000000],
            [103189, 0.000000],
            [103284, 0.000000],
            [102922, 0.000000],
            [103040, 0.000000],
            [103430, 0.000000],
            [10647, 0.000000],
            [21605, 0.000000],
            [103160, 0.000000],
            [103227, 0.000000],
            [29371, 0.000000],
            [29550, 0.000000],
            [27725, 0.000000],
            [103136, 0.000000],
            [103356, 0.000000],
            [103520, 0.000000],
            [21595, 0.000000],
            [104891, 0.000000],
            [104828, 0.000000],
            [20833, 0.000000],
            [13456, 0.000000],
            [15714, 0.000000],
            [100679, 0.000000],
            [11413, 0.000000],
            [103427, 0.000000],
            [16171, 0.000000],
            [103404, 0.000000],
            [104615, 0.000000],
            [103428, 0.000000],
            [103323, 0.000000],
            [104878, 0.000000],
            [103334, 0.000000],
            [21415, 0.000000],
            [21726, 0.000000],
            [103286, 0.000000],
            [10764, 0.000000],
            [21024, 0.000000],
            [21084, 0.000000],
            [28518, 0.000000],
            [20551, 0.000000],
            [101597, 0.000000],
            [27166, 0.000000],
            [98536, 0.000000],
            [103267, 0.000000],
            [103083, 0.000000],
            [103290, 0.000000],
            [102960, 0.000000],
            [10994, 0.000000],
            [103254, 0.000000],
            [103658, 0.000000],
            [103180, 0.000000],
            [21222, 0.000000],
            [103101, 0.000000],
            [104834, 0.000000],
            [21221, 0.000000],
            [103442, 0.000000],
            [26437, 0.000000],
            [103192, 0.000000],
            [103759, 0.000000],
            [10663, 0.000000],
            [103315, 0.000000],
            [103540, 0.000000],
            [61982, 0.000000],
            [103422, 0.000000],
            [21375, 0.000000],
            [103395, 0.000000],
            [103216, 0.000000],
            [102887, 0.000000],
            [21452, 0.000000],
            [102983, 0.000000],
            [104594, 0.000000],
            [103393, 0.000000],
            [104812, 0.000000],
            [20972, 0.000000],
            [103128, 0.000000],
            [103359, 0.000000],
            [29375, 0.000000],
            [103489, 0.000000],
            [103622, 0.000000],
            [103122, 0.000000],
            [10591, 0.000000],
            [104217, 0.000000],
            [103256, 0.000000],
            [102880, 0.000000],
            [21228, 0.000000],
            [27275, 0.000000],
            [103386, 0.000000],
            [28013, 0.000000],
            [103028, 0.000000],
            [103230, 0.000000],
            [27769, 0.000000],
            [11183, 0.000000],
            [102927, 0.000000],
            [102936, 0.000000],
            [38345, 0.000000],
            [103211, 0.000000],
            [10512, 0.000000],
            [28897, 0.000000],
            [101467, 0.000000],
            [10669, 0.000000],
            [21656, 0.000000],
            [103419, 0.000000],
            [21165, 0.000000],
            [103841, 0.000000],
            [101804, 0.000000],
            [10986, 0.000000],
            [10419, 0.000000],
            [103448, 0.000000],
            [10137, 0.000000],
            [103233, 0.000000],
            [103447, 0.000000],
            [21642, 0.000000],
            [103459, 0.000000],
            [101757, 0.000000],
            [103534, 0.000000],
            [103426, 0.000000],
            [10634, 0.000000],
            [103263, 0.000000],
            [103337, 0.000000],
            [103436, 0.000000],
            [29588, 0.000000],
            [104315, 0.000000],
            [103638, 0.000000],
            [29496, 0.000000],
            [101387, 0.000000],
            [103063, 0.000000],
            [103168, 0.000000],
            [10378, 0.000000],
            [29569, 0.000000],
            [102964, 0.000000],
            [103272, 0.000000],
            [104906, 0.000000],
            [102949, 0.000000],
            [102909, 0.000000],
            [103416, 0.000000],
            [21255, 0.000000],
            [103475, 0.000000],
            [103495, 0.000000],
            [102924, 0.000000],
            [20122, 0.000000],
            [103636, 0.000000],
            [102991, 0.000000],
            [21626, 0.000000],
            [21586, 0.000000],
            [103058, 0.000000],
            [20693, 0.000000],
            [103324, 0.000000],
            [20250, 0.000000],
            [103318, 0.000000],
            [28302, 0.000000],
            [104896, 0.000000],
            [103213, 0.000000],
            [104618, 0.000000],
            [103292, 0.000000],
            [10319, 0.000000],
            [102159, 0.000000],
            [20153, 0.000000],
            [101431, 0.000000],
            [104492, 0.000000],
            [103111, 0.000000],
            [103357, 0.000000],
            [10499, 0.000000],
            [103222, 0.000000],
            [101688, 0.000000],
            [103514, 0.000000],
            [11052, 0.000000],
            [103287, 0.000000],
            [101698, 0.000000],
            [103251, 0.000000],
            [102886, 0.000000],
            [103236, 0.000000],
            [21554, 0.000000],
            [101609, 0.000000],
            [29427, 0.000000],
            [103009, 0.000000],
            [36974, 0.000000],
            [103196, 0.000000],
            [103325, 0.000000],
            [103483, 0.000000],
            [103195, 0.000000],
            [103306, 0.000000],
            [37141, 0.000000],
            [103176, 0.000000],
            [103407, 0.000000],
            [29546, 0.000000],
            [21513, 0.000000],
            [102918, 0.000000],
            [103316, 0.000000],
            [103319, 0.000000],
            [102976, 0.000000],
            [103199, 0.000000],
            [10626, 0.000000],
            [28468, 0.000000],
            [21552, 0.000000],
            [20668, 0.000000],
            [104914, 0.000000],
            [10030, 0.000000],
            [27732, 0.000000],
            [103281, 0.000000],
            [21128, 0.000000],
            [102755, 0.000000],
            [103491, 0.000000],
            [37154, 0.000000],
            [103307, 0.000000],
            [11135, 0.000000],
            [103137, 0.000000],
            [103623, 0.000000],
            [104612, 0.000000],
            [11387, 0.000000],
            [103663, 0.000000],
            [21332, 0.000000],
            [21286, 0.000000],
            [29413, 0.000000],
            [21584, 0.000000],
            [104807, 0.000000],
            [21196, 0.000000],
            [20549, 0.000000],
            [104895, 0.000000],
            [103105, 0.000000],
            [104340, 0.000000],
            [101067, 0.000000],
            [103450, 0.000000],
            [103425, 0.000000],
            [10588, 0.000000],
            [29584, 0.000000],
            [103055, 0.000000],
            [21339, 0.000000],
            [104831, 0.000000],
            [103117, 0.000000],
            [10771, 0.000000],
            [103024, 0.000000],
            [103424, 0.000000],
            [100979, 0.000000],
            [103533, 0.000000],
            [21688, 0.000000],
            [10720, 0.000000],
            [103109, 0.000000],
            [103466, 0.000000],
            [103455, 0.000000],
            [103149, 0.000000],
            [104900, 0.000000],
            [104525, 0.000000],
            [100912, 0.000000],
            [103453, 0.000000],
            [11196, 0.000000],
            [103528, 0.000000],
            [20759, 0.000000],
            [20963, 0.000000],
            [20248, 0.000000],
            [103322, 0.000000],
            [103362, 0.000000],
            [11478, 0.000000],
            [103043, 0.000000],
            [103268, 0.000000],
            [103446, 0.000000],
            [100363, 0.000000],
            [103474, 0.000000],
            [100519, 0.000000],
            [27157, 0.000000],
            [103423, 0.000000],
            [103080, 0.000000],
            [20653, 0.000000],
            [103476, 0.000000],
            [10631, 0.000000],
            [20808, 0.000000],
            [29074, 0.000000],
            [103390, 0.000000],
            [26657, 0.000000],
            [104333, 0.000000],
            [20098, 0.000000],
            [103114, 0.000000],
            [104890, 0.000000],
            [103100, 0.000000],
            [20784, 0.000000],
            [103490, 0.000000],
            [10955, 0.000000],
            [28259, 0.000000],
            [103660, 0.000000],
            [103064, 0.000000],
            [103328, 0.000000],
            [104909, 0.000000],
            [103605, 0.000000],
            [27104, 0.000000],
            [104412, 0.000000],
            [103321, 0.000000],
            [103661, 0.000000],
            [102816, 0.000000],
            [104860, 0.000000],
            [103515, 0.000000],
            [103417, 0.000000],
            [103274, 0.000000],
            [11496, 0.000000],
            [104771, 0.000000],
            [21371, 0.000000],
            [20897, 0.000000],
            [103439, 0.000000],
            [103039, 0.000000],
            [21229, 0.000000],
            [103084, 0.000000],
            [21633, 0.000000],
            [10382, 0.000000],
            [20745, 0.000000],
            [103403, 0.000000],
            [10421, 0.000000],
            [103126, 0.000000],
            [101751, 0.000000],
            [103524, 0.000000],
            [103052, 0.000000],
            [10231, 0.000000],
            [102802, 0.000000],
            [10532, 0.000000],
            [103832, 0.000000],
            [103435, 0.000000],
            [102926, 0.000000],
            [10698, 0.000000],
            [62457, 0.000000],
            [103166, 0.000000],
            [29421, 0.000000],
            [10332, 0.000000],
            [102975, 0.000000],
            [21099, 0.000000],
            [103494, 0.000000],
            [28490, 0.000000],
            [11484, 0.000000],
            [102902, 0.000000],
            [104230, 0.000000],
            [20855, 0.000000],
            [103517, 0.000000],
            [11112, 0.000000],
            [10968, 0.000000],
            [20249, 0.000000],
            [21419, 0.000000],
            [29220, 0.000000],
            [104325, 0.000000],
            [103074, 0.000000],
            [20995, 0.000000],
            [20138, 0.000000],
            [103191, 0.000000],
            [103042, 0.000000],
            [20928, 0.000000],
            [103317, 0.000000],
            [102878, 0.000000],
            [103349, 0.000000],
            [101392, 0.000000],
            [101807, 0.000000],
            [104406, 0.000000],
            [103178, 0.000000],
            [103498, 0.000000],
            [21475, 0.000000],
            [20797, 0.000000],
            [103458, 0.000000],
            [21568, 0.000000],
            [103339, 0.000000],
            [21354, 0.000000],
            [104918, 0.000000],
            [11109, 0.000000],
            [104858, 0.000000],
            [20679, 0.000000],
            [103099, 0.000000],
            [10804, 0.000000],
            [103624, 0.000000],
            [104810, 0.000000],
            [21314, 0.000000],
            [101820, 0.000000],
            [103587, 0.000000],
            [102873, 0.000000],
            [11263, 0.000000],
            [103384, 0.000000],
            [103041, 0.000000],
            [102952, 0.000000],
            [103075, 0.000000],
            [104835, 0.000000],
            [29433, 0.000000],
            [11047, 0.000000],
            [103664, 0.000000],
            [28582, 0.000000],
            [11932, 0.000000],
            [11379, 0.000000],
            [29642, 0.000000],
            [103496, 0.000000],
            [102876, 0.000000],
            [104134, 0.000000],
            [21018, 0.000000],
            [103433, 0.000000],
            [21291, 0.000000],
            [20994, 0.000000],
            [100649, 0.000000],
            [10449, 0.000000],
            [103071, 0.000000],
            [103399, 0.000000],
            [10149, 0.000000],
            [29419, 0.000000],
            [103094, 0.000000],
            [101588, 0.000000],
            [103124, 0.000000],
            [102847, 0.000000],
            [28742, 0.000000],
            [21585, 0.000000],
            [103354, 0.000000],
            [103827, 0.000000],
            [103255, 0.000000],
            [10114, 0.000000],
            [26003, 0.000000],
            [103516, 0.000000],
            [20734, 0.000000],
            [104837, 0.000000],
            [21625, 0.000000],
            [103817, 0.000000],
            [20870, 0.000000],
            [104425, 0.000000],
            [10763, 0.000000],
            [40689, 0.000000],
            [21000, 0.000000],
            [102870, 0.000000],
            [103232, 0.000000],
            [28903, 0.000000],
            [101536, 0.000000],
            [21476, 0.000000],
            [10450, 0.000000],
            [28411, 0.000000],
            [21107, 0.000000],
            [29466, 0.000000],
            [103179, 0.000000],
            [103252, 0.000000],
            [103348, 0.000000],
            [20025, 0.000000],
            [21141, 0.000000],
            [20598, 0.000000],
            [103134, 0.000000],
            [104192, 0.000000],
            [98611, 0.000000],
            [20818, 0.000000],
            [27605, 0.000000],
            [94287, 0.000000],
            [21047, 0.000000],
            [100459, 0.000000],
            [104620, 0.000000],
            [103657, 0.000000],
            [20888, 0.000000],
            [101447, 0.000000],
            [104866, 0.000000],
            [27393, 0.000000],
            [101555, 0.000000],
            [21101, 0.000000],
            [103440, 0.000000],
            [103656, 0.000000],
            [21367, 0.000000],
            [10997, 0.000000],
            [10674, 0.000000],
            [26008, 0.000000],
            [20045, 0.000000],
            [21534, 0.000000],
            [20781, 0.000000],
            [104592, 0.000000],
            [20953, 0.000000],
            [104625, 0.000000],
            [103460, 0.000000],
            [103510, 0.000000],
            [103224, 0.000000],
            [103295, 0.000000],
            [101111, 0.000000],
            [103518, 0.000000],
            [103612, 0.000000],
            [101516, 0.000000],
            [101524, 0.000000],
            [20947, 0.000000],
            [103526, 0.000000],
            [27346, 0.000000],
            [21559, 0.000000],
            [103171, 0.000000],
            [103361, 0.000000],
            [103434, 0.000000],
            [21593, 0.000000],
            [20929, 0.000000],
            [103373, 0.000000],
            [10778, 0.000000],
            [21108, 0.000000],
            [21576, 0.000000],
            [27551, 0.000000],
            [20648, 0.000000],
            [103532, 0.000000],
            [103262, 0.000000],
            [21177, 0.000000],
            [104402, 0.000000],
            [27827, 0.000000],
            [20050, 0.000000],
            [21550, 0.000000],
            [104875, 0.000000],
            [20103, 0.000000],
            [103023, 0.000000],
            [29638, 0.000000],
            [20708, 0.000000],
            [103240, 0.000000],
            [103142, 0.000000],
            [10660, 0.000000],
            [62419, 0.000000],
            [100782, 0.000000],
            [103640, 0.000000],
            [103057, 0.000000],
            [20737, 0.000000],
            [100786, 0.000000],
            [103312, 0.000000],
            [100583, 0.000000],
            [27703, 0.000000],
            [40608, 0.000000],
            [103484, 0.000000],
            [102968, 0.000000],
            [10383, 0.000000],
            [11006, 0.000000],
            [29404, 0.000000],
            [60461, 0.000000],
            [101501, 0.000000],
            [11421, 0.000000],
            [21465, 0.000000],
            [20689, 0.000000],
            [102938, 0.000000],
            [20011, 0.000000],
            [104871, 0.000000],
            [98574, 0.000000],
            [103509, 0.000000],
            [28453, 0.000000],
            [104848, 0.000000],
            [29124, 0.000000],
            [10143, 0.000000],
            [103535, 0.000000],
            [11199, 0.000000],
            [60101, 0.000000],
            [103855, 0.000000],
            [100398, 0.000000],
            [103467, 0.000000],
            [103645, 0.000000],
            [103760, 0.000000],
            [104832, 0.000000],
            [21455, 0.000000],
            [103078, 0.000000],
            [102881, 0.000000],
            [103375, 0.000000],
            [103198, 0.000000],
            [103021, 0.000000],
            [103480, 0.000000],
            [103277, 0.000000],
            [103285, 0.000000],
            [103506, 0.000000],
            [100688, 0.000000],
            [20946, 0.000000],
            [10256, 0.000000],
            [104347, 0.000000],
            [11099, 0.000000],
            [20825, 0.000000],
            [20700, 0.000000],
            [101602, 0.000000],
            [104171, 0.000000],
            [97014, 0.000000],
            [103344, 0.000000],
            [103441, 0.000000],
            [103276, 0.000000],
            [10328, 0.000000],
            [104155, 0.000000],
            [28484, 0.000000],
            [21760, 0.000000],
            [101592, 0.000000],
            [63820, 0.000000],
            [29458, 0.000000],
            [20139, 0.000000],
            [103452, 0.000000],
            [103445, 0.000000],
            [29397, 0.000000],
            [103228, 0.000000],
            [102942, 0.000000],
            [27274, 0.000000],
            [20983, 0.000000],
            [21181, 0.000000],
            [103341, 0.000000],
            [20976, 0.000000],
            [20628, 0.000000],
            [27210, 0.000000],
            [11037, 0.000000],
            [103050, 0.000000],
            [10845, 0.000000],
            [103374, 0.000000],
            [103162, 0.000000],
            [10136, 0.000000],
            [32087, 0.000000],
            [101591, 0.000000],
            [102829, 0.000000],
            [103652, 0.000000],
            [20660, 0.000000],
            [20710, 0.000000],
            [21443, 0.000000],
            [26335, 0.000000],
            [103293, 0.000000],
            [103311, 0.000000],
            [103644, 0.000000],
            [101554, 0.000000],
            [11181, 0.000000],
            [10977, 0.000000],
            [20274, 0.000000],
            [20775, 0.000000],
            [29585, 0.000000],
            [103044, 0.000000],
            [103248, 0.000000],
            [103669, 0.000000],
            [28480, 0.000000],
            [20036, 0.000000],
            [98426, 0.000000],
            [20163, 0.000000],
            [102911, 0.000000],
            [104168, 0.000000],
            [20757, 0.000000],
            [103003, 0.000000],
            [102977, 0.000000],
            [27164, 0.000000],
            [10433, 0.000000],
            [20900, 0.000000],
            [10396, 0.000000],
            [103477, 0.000000],
            [21218, 0.000000],
            [21795, 0.000000],
            [21089, 0.000000],
            [20892, 0.000000],
            [10632, 0.000000],
            [21203, 0.000000],
            [28413, 0.000000],
            [103327, 0.000000],
            [101526, 0.000000],
            [28836, 0.000000],
            [20663, 0.000000],
            [28866, 0.000000],
            [104369, 0.000000],
            [11000, 0.000000],
            [21432, 0.000000],
            [102950, 0.000000],
            [27937, 0.000000],
            [103649, 0.000000],
            [103507, 0.000000],
            [103280, 0.000000],
            [20762, 0.000000],
            [10399, 0.000000],
            [29640, 0.000000],
            [103478, 0.000000],
            [29024, 0.000000],
            [103380, 0.000000],
            [21095, 0.000000],
            [28723, 0.000000],
            [27955, 0.000000],
            [103796, 0.000000],
            [17117, 0.000000],
            [29418, 0.000000],
            [103244, 0.000000],
            [11362, 0.000000],
            [104897, 0.000000],
            [103502, 0.000000],
            [20821, 0.000000],
            [101521, 0.000000],
            [3963, 0.000000],
            [104187, 0.000000],
            [20039, 0.000000],
            [11198, 0.000000],
            [10506, 0.000000],
            [100536, 0.000000],
            [21599, 0.000000],
            [28780, 0.000000],
            [103347, 0.000000],
            [10554, 0.000000],
            [101319, 0.000000],
            [26659, 0.000000],
            [103182, 0.000000],
            [104226, 0.000000],
            [21350, 0.000000],
            [103464, 0.000000],
            [103659, 0.000000],
            [10998, 0.000000],
            [10920, 0.000000],
            [27577, 0.000000],
            [103611, 0.000000],
            [103139, 0.000000],
            [28122, 0.000000],
            [21639, 0.000000],
            [104593, 0.000000],
            [104175, 0.000000],
            [103493, 0.000000],
            [103479, 0.000000],
            [100502, 0.000000],
            [103181, 0.000000],
            [103336, 0.000000],
            [27844, 0.000000],
            [101654, 0.000000],
            [103400, 0.000000],
            [10461, 0.000000],
            [10338, 0.000000],
            [11082, 0.000000],
            [100486, 0.000000],
            [21295, 0.000000],
            [21059, 0.000000],
            [29648, 0.000000],
            [104310, 0.000000],
            [101607, 0.000000],
            [101587, 0.000000],
            [103298, 0.000000],
            [103396, 0.000000],
            [100663, 0.000000],
            [21769, 0.000000],
            [21562, 0.000000],
            [28963, 0.000000],
            [27399, 0.000000],
            [97231, 0.000000],
            [28223, 0.000000],
            [104133, 0.000000],
            [103156, 0.000000],
            [101389, 0.000000],
            [103367, 0.000000],
            [20256, 0.000000],
            [8547, 0.000000],
            [103271, 0.000000],
            [28904, 0.000000],
            [28754, 0.000000],
            [100648, 0.000000],
            [27684, 0.000000],
            [10702, 0.000000],
            [10617, 0.000000],
            [28313, 0.000000],
            [21009, 0.000000],
            [102979, 0.000000],
            [104490, 0.000000],
            [27043, 0.000000],
            [103508, 0.000000],
            [103625, 0.000000],
            [104170, 0.000000],
            [28525, 0.000000],
            [20579, 0.000000],
            [103091, 0.000000],
            [103352, 0.000000],
            [10067, 0.000000],
            [104304, 0.000000],
            [10794, 0.000000],
            [27940, 0.000000],
            [20692, 0.000000],
            [102245, 0.000000],
            [27008, 0.000000],
            [103330, 0.000000],
            [104365, 0.000000],
            [29467, 0.000000],
            [27544, 0.000000],
            [100490, 0.000000],
            [11267, 0.000000],
            [103059, 0.000000],
            [103870, 0.000000],
            [10386, 0.000000],
            [103631, 0.000000],
            [28889, 0.000000],
            [36948, 0.000000],
            [20035, 0.000000],
            [21324, 0.000000],
            [28911, 0.000000],
            [103503, 0.000000],
            [21300, 0.000000],
            [103204, 0.000000],
            [101574, 0.000000],
            [29127, 0.000000],
            [27826, 0.000000],
            [29376, 0.000000],
            [21413, 0.000000],
            [104884, 0.000000],
            [28997, 0.000000],
            [101276, 0.000000],
            [28614, 0.000000],
            [103177, 0.000000],
            [10717, 0.000000],
            [20906, 0.000000],
            [101441, 0.000000],
            [103073, 0.000000],
            [11383, 0.000000],
            [103309, 0.000000],
            [21001, 0.000000],
            [104321, 0.000000],
            [27658, 0.000000],
            [104460, 0.000000],
            [29114, 0.000000],
            [100731, 0.000000],
            [100481, 0.000000],
            [101461, 0.000000],
            [103486, 0.000000],
            [20916, 0.000000],
            [103392, 0.000000],
            [21116, 0.000000],
            [10962, 0.000000],
            [15300, 0.000000],
            [102987, 0.000000],
            [28827, 0.000000],
            [102998, 0.000000],
            [11049, 0.000000],
            [29649, 0.000000],
            [101662, 0.000000],
            [102775, 0.000000],
            [103843, 0.000000],
            [27588, 0.000000],
            [104580, 0.000000],
            [104641, 0.000000],
            [103146, 0.000000],
            [20884, 0.000000],
            [21106, 0.000000],
            [103621, 0.000000],
            [10454, 0.000000],
            [21096, 0.000000],
            [20167, 0.000000],
            [101280, 0.000000],
            [103437, 0.000000],
            [11303, 0.000000],
            [101601, 0.000000],
            [11420, 0.000000],
            [103123, 0.000000],
            [21251, 0.000000],
            [20794, 0.000000],
            [27176, 0.000000],
            [101623, 0.000000],
            [26438, 0.000000],
            [21290, 0.000000],
            [26836, 0.000000],
            [100742, 0.000000],
            [21100, 0.000000],
            [10925, 0.000000],
            [43444, 0.000000],
            [103886, 0.000000],
            [11430, 0.000000],
            [21373, 0.000000],
            [26016, 0.000000],
            [40115, 0.000000],
            [21451, 0.000000],
            [21127, 0.000000],
            [10311, 0.000000],
            [103144, 0.000000],
            [20905, 0.000000],
            [28957, 0.000000],
            [21216, 0.000000],
            [103133, 0.000000],
            [20739, 0.000000],
            [100499, 0.000000],
            [104323, 0.000000],
            [101509, 0.000000],
            [10141, 0.000000],
            [28077, 0.000000],
            [11300, 0.000000],
            [21433, 0.000000],
            [21533, 0.000000],
            [28776, 0.000000],
            [100528, 0.000000],
            [20051, 0.000000],
            [10320, 0.000000],
            [11268, 0.000000],
            [102752, 0.000000],
            [103332, 0.000000],
            [102830, 0.000000]
];

my $sql = 'INSERT INTO serp_geo_stat (region, coef) VALUES %s';
my $count = do_mass_insert_sql(PPCDICT, $sql, $data);
$log->out("$count rows inserted");

