#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use User;
use RBAC2::Extended;
use RBACDirect;

=head1 DEPLOY

# approved by zhur
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '1 sec',
    comment => 'Сбрасываем блокировку кармы для агентсв и их клиентов',
}

=cut

my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
die "Can't connect to RBAC" if ! defined $rbac || ! $rbac->InitReq(1);
for my $uid (@{get_one_column_sql(PPCDICT, "select distinct uid from bad_karma_clients")}) {
    my $client_have_agency = rbac_has_agency($rbac, $uid);
    my $role = rbac_who_is($rbac, $uid);
    my $can_block_karma = $role =~ /client/ && ! $client_have_agency
                              && ! scalar @{rbac_get_managers_of_client($rbac, $uid)} ? 1 : 0;
    if (!$can_block_karma) {
        $log->out("remove block for uid $uid");
        do_delete_from_table(PPCDICT, 'bad_karma_clients', where => { uid => $uid });
    }
}

