#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur 
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'на devtest: 6 мин',
        comment => 'установка автоброкера для кампаний с остановленным поиском',
    }

=cut

use strict;
use warnings;
use utf8;

use Data::Dumper;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

my @bids = sort {$a <=> $b} @{get_one_column_sql(PPC_HEAVY, <<EOS) || []};
    SELECT STRAIGHT_JOIN
        b.id
    FROM
        camp_options co
        JOIN bids b ON co.cid = b.cid
    WHERE
        co.is_search_stop = 1
    AND
        b.AutoBroker <> 'Yes'
EOS

$log->out('updating autobroker ' . scalar(@bids) . ' phrases');


my $sql = q[
UPDATE 
    bids b
    JOIN camp_options co ON co.cid = b.cid
SET b.AutoBroker = 'Yes',
    b.statusBsSynced = 'No',
    b.warn = 'Yes'
WHERE
    b.id IN (%s)
AND
    co.is_search_stop = 1
AND
    b.AutoBroker <> 'Yes'];

my @chunk;
while(@chunk = splice @bids, 0, 100) {
    do_sql(PPC, sprintf $sql, join ',', @chunk)
}

$log->out('updated autobroker done');