#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use JSON;

=head1 DEPLOY

# approved by zhur
# .migr
[{
  webstop => "0",
  type => 'sql',
  db => "monitor",
  time_estimate => "1 sec",
  when => 'before',
  sql => [
         "alter table log_strategy_change
            add new_strategy_name varchar(128) not null default ''
            , add old_strategy_name varchar(128) not null default ''
         ",
    ]
},
    {
        type => 'script',
        when => 'after',
        time_estimate => '3 min',
        comment => 'заполняем таблицу log_strategy_change новые колонки new_strategy_name, old_strategy_name',
    }

]

=cut

# -----------------------------------------------------------------------------
sub main {
    my $MAX_ITER = 10;

    for my $iter (0 .. $MAX_ITER - 1) {
        for my $row (@{get_all_sql(MONITOR, "select cid, data_json, logtime
                                             from log_strategy_change
                                             where cid mod $MAX_ITER = $iter
                                               and new_strategy_name = ''
                                            ")}
                    )
        {

            my $data = from_json($row->{data_json}, {utf8  => 1});
            my $new_strategy_name = $data->{new}->{budget_strategy} ? "easy:$data->{new}->{budget_strategy}" : $data->{new}->{_strategy_name} || '';
            my $old_strategy_name = $data->{old}->{_strategy_name} || '';

            do_update_table(MONITOR
                            , 'log_strategy_change'
                            , {new_strategy_name => $new_strategy_name
                               , old_strategy_name => $old_strategy_name
                              }
                            , where => {cid => $row->{cid}
                                        , logtime => $row->{logtime}
                                        , data_json => $row->{data_json}
                                        }
                           );
            $log->out("$iter $row->{cid} $new_strategy_name $old_strategy_name");
        }
    }
}

main();
