#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use List::MoreUtils qw/uniq/;
$|++;


=head1 DEPLOY

# approved by zhur
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '20 min',
    comment => 'обновляем geo у кампаний и фраз',
}
=cut

# что на что меняем
my %changed = (
    166 => [169, 166], # СНГ (исключая Россию) => Грузия, СНГ (исключая Россию)
    26 => [102444, 26], # Юг => Республика Дагестан, Республика Ингушетия, Республика Кабардино-Балкария, Карачаево-Черкесская Республика, Республика Северная Осетия-Алания, Чеченская Республика, Ессентуки, Кисловодск, Минеральные Воды, Невинномысск, Пятигорск, Ставропольский край, Ставрополь, Юг
    183 => [183, -169 ], # Азия =>  (кроме: Грузия), Азия
);

my $changed_sql = join " OR ", 
    map { " geo = '$_' or geo like '$_,%' or geo like '%,$_' or geo like '%,$_,%' or geo like '%,-$_,%' or geo like '%,-$_'\n" } keys %changed;

$log->out('start');
my $sth = exec_sql(PPC,"select cid, geo from campaigns where $changed_sql");
$log->out('updating campaigns');
my %update;
my $cnt = 0;
my $skip = 0;
while (my ($cid, $geo) = $sth->fetchrow_array()) {
    my (@geo) = split /,/, $geo;
    my $new_geo = new_geo($geo);
    if ($new_geo ne $geo) {
        $update{$cid}{geo} = $geo;
        $update{$cid}{new_geo} = $new_geo;
        $log->out("$cid: '$geo' => '$new_geo'");
        $cnt++;
    }
    else {
        $skip++;
    }
    if (scalar keys %update >= 500) {
        do_sql(PPC, [ "update campaigns set geo = case cid ".( join ' ', map { " when $_ then '$update{$_}{new_geo}' " } keys %update )." else geo end ", 
                where => { cid => [ keys %update ], geo => [ map { $update{$_}{geo} } keys %update ] } ]);
        %update = ();
    }
}
if (keys %update) {
    do_sql(PPC, [ "update campaigns set geo = case cid ".( join ' ', map { " when $_ then '$update{$_}{new_geo}' " } keys %update )." else geo end ", 
            where => { cid => [ keys %update ], geo => [ map { $update{$_}{geo} } keys %update ] } ]);
    %update = ();
}
$log->out("table campaigns: $cnt updated, $skip skipped");

$cnt = $skip = 0;
$sth = exec_sql(PPC,"select pid, cid, geo from phrases join banners using(bid) where $changed_sql");
$log->out("updating phrases");
while (my ($cid, $pid, $geo) = $sth->fetchrow_array()) {
    my $new_geo = new_geo($geo);
    if ($new_geo ne $geo) {
        $update{$pid}{geo} = $geo;
        $update{$pid}{new_geo} = $new_geo;
        $update{$pid}{cid} = $cid;
        $log->out("$pid: '$geo' => '$new_geo'");
        $cnt++;
    }
    else {
        $skip++;
    }
    if (scalar keys %update >= 500) {
        do_mass_insert_sql(PPC,"INSERT IGNORE INTO bs_resync_queue (cid, pid) VALUES %s", [ map { [ $update{$_}{cid}, $_ ] } keys %update ]);
        do_sql(PPC, [ "update phrases set geo = case pid ".( join ' ', map { " when $_ then '$update{$_}{new_geo}' " } keys %update )." else geo end ", 
                where => { 
                    pid => [ keys %update ], 
                    geo => [ map { $update{$_}{geo} } keys %update ] 
                }
        ]);
        %update = ();
    }
}
if (scalar keys %update) {
    do_mass_insert_sql(PPC,"INSERT IGNORE INTO bs_resync_queue (cid, pid) VALUES %s", [ map { [ $update{$_}{cid}, $_ ] } keys %update ]);
    do_sql(PPC, [ "update phrases set geo = case pid ".( join ' ', map { " when $_ then '$update{$_}{new_geo}' " } keys %update )." else geo end ", 
            where => { 
                pid => [ keys %update ], 
                geo => [ map { $update{$_}{geo} } keys %update ] 
            }
    ]);
}
$log->out("table phrases: $cnt updated, $skip skipped");
$log->out('end');

###############

sub new_geo
{
    my ($geo) = @_;
    my @geo = split /,/, $geo;
    my @new_geo = map { 
        my $minus = $_ < 0 ? -1 : 1;
        $_ = abs $_;
        $changed{$_} ? (map { $minus * $_ } @{$changed{$_}}) : $minus * $_ ; } @{[@geo]};
    # [ 166,-169 ] => [ 166,169,-169 ] => [ 166 ] # два региона аннигилировали
    # [ 166,183 ] => [ 166,169,183,-169 ] => [ 166, 183 ] # тоже ок, грузия переехала из снг в азию, ничего менять не надо ^^
    # [ 166,-169,183 ] => [ 166,169,-169,183,169 ] => [ 166,183,-169 ] # -169,-169,+169 -регион попадает в результат
    my (%plus_geo, %minus_geo); map { if ($_ > 0) { $plus_geo{$_}++ } else { $minus_geo{abs($_)}++ } } @new_geo;
    @new_geo = uniq map { $_=abs($_); ($plus_geo{$_}||0) > ($minus_geo{$_}||0) ? $_ : -$_ } (@new_geo); 
    my $new_geo = join ',', @new_geo;
    return $new_geo;
}


