#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'На продакшене порядка 4 часов',
        comment => q[
            Удаляем поле sessions_cost из таблиц со статистикой.
            Параметры запуска - номера инстанса базы на которых будет применена миграция. 
            
            Как запускать:
            20111201_drop_column_sessions_cost.pl 1 2 3 4 5 6
        ],
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

foreach (map {/^(ppcstat:)?(\d+)$/ ? $2 : ()} @ARGV) {

    $log->out("ppcstat:$_ start");
    my $dbh = connect_db(get_db_config("ppcstat:$_"));
    drop_column($dbh, $_);
    disconnect_db($dbh);
    $log->out("ppcstat:$_ finish");
}

sub drop_column {
 
    my ($dbh, $instance) = @_;
    
    my $tables = get_one_column_sql($dbh, q[SHOW TABLES IN ppcstat_data LIKE 'order_stat_%']);
    my ($q, $total) = (0, scalar @$tables);
    
    $dbh->{HandleError} = sub {return 1};
    foreach my $t (@$tables) {
        my $oid = ($t =~ /^order_stat_(\d+)$/)[0];
        foreach (qw/stat stat_day stat_small/) {
            eval {do_sql($dbh, qq[ALTER TABLE ppcstat_data.order_${_}_$oid DROP COLUMN sessions_cost])};
            $log->out("ppcstat:$instance order_${_}_$oid: " . $@) if $@;
        }
        $log->out("ppcstat:$instance order_stat $q/$total tables done") unless ++$q % 1000;
    }
}
