#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'sql',
  webstop => 0,
  db => "ppc",
  when => 'before',
  time_estimate => "1 сек.",
  sql => "RENAME TABLE mass_change_owner_queue TO old_mass_change_owner_queue",
},
{
  type => 'sql',
  webstop => 0,
  db => "ppcdict",
  when => 'before',
  time_estimate => "1 сек.",
  sql => "CREATE TABLE `mass_change_owner_queue` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uid` bigint(20) NOT NULL default '0',
  `status` enum('Wait','Send','Error') NOT NULL default 'Wait',
  `object_type` enum('Cid','Agency','Manager') NOT NULL,
  `object_id` bigint(20) NOT NULL default '0' COMMENT 'cid or manager/agency uid',
  `old_owner` bigint(20) NOT NULL default '0' COMMENT 'manager or teamleader',
  `new_owner` bigint(20) NOT NULL default '0' COMMENT 'manager or teamleader',
  `add_time` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `send_time` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8"
},
{
  type => 'script',
  when => 'after',
  time_estimate => "10 сек.",
  comment => "запустить на ppcback01f"
}
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;

my $CHUNK_SIZE = 1_000;

$log->out("start");
my $sth = exec_sql(PPC, "
                    SELECT uid, status, object_type, object_id, old_owner, new_owner, add_time, send_time
                      FROM old_mass_change_owner_queue
                      ");
while(my $chunk = $sth->fetchall_arrayref([], $CHUNK_SIZE)) {
    $log->out(sprintf "new chunk with %d rows", scalar(@$chunk));
    do_mass_insert_sql(PPCDICT, "INSERT IGNORE INTO mass_change_owner_queue
                                    (uid, status, object_type, object_id, old_owner, new_owner, add_time, send_time)
                                    VALUES %s
                                ", $chunk);
    last if @$chunk < $CHUNK_SIZE;
}
$log->out("finish");
