#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'sql',
  webstop => 0,
  db => "monitor",
  when => 'before',
  time_estimate => "1 сек.",
  sql => "CREATE TABLE `mcb_theme_mutations` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `data` longtext NOT NULL,
  `changed_ratio` tinyint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8"
},
{
  type => 'script',
  when => 'after',
  time_estimate => "2 мин.",
  comment => "запустить на ppcback01f"
}
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;

my $CHUNK_SIZE = 10;

$log->out("start");
get_dbh(PPC_HEAVY)->{mysql_use_result} = 1;
my $sth = exec_sql(PPC_HEAVY, "
                    SELECT id, date_from, date_to, data, changed_ratio
                      FROM mcb_theme_mutations
                      ");
while(my $chunk = $sth->fetchall_arrayref([], $CHUNK_SIZE)) {
    $log->out(sprintf "new chunk with %d rows", scalar(@$chunk));
    do_mass_insert_sql(MONITOR, "INSERT IGNORE INTO mcb_theme_mutations
                                    (id, date_from, date_to, data, changed_ratio)
                                    VALUES %s
                                ", $chunk);
    last if @$chunk < $CHUNK_SIZE;
}
$log->out("finish");
