#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'sql',
  webstop => 0,
  db => "monitor",
  when => 'before',
  time_estimate => "1 сек.",
  sql => "CREATE TABLE `redirect_check_dict` (
  `href` varchar(255) NOT NULL,
  `redirect` varchar(255) NOT NULL,
  `domain_redir` varchar(100) NOT NULL,
  `logdate` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `domain` varchar(255) NOT NULL default '',
  UNIQUE KEY `href` (`href`),
  KEY `logdate` (`logdate`),
  KEY `domain` (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8"
},
{
  type => 'script',
  when => 'after',
  time_estimate => "2 мин.",
  comment => "запустить на ppcback01f"
}
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;

my $CHUNK_SIZE = 1_000;

$log->out("start");
get_dbh(PPC_HEAVY)->{mysql_use_result} = 1;
my $sth = exec_sql(PPC_HEAVY, "
                    SELECT href, redirect, domain_redir, logdate, domain
                      FROM redirect_check_dict
                      ");
while(my $chunk = $sth->fetchall_arrayref([], $CHUNK_SIZE)) {
    $log->out(sprintf "new chunk with %d rows", scalar(@$chunk));
    do_mass_insert_sql(MONITOR, "INSERT IGNORE INTO redirect_check_dict 
                                    (href, redirect, domain_redir, logdate, domain)
                                    VALUES %s
                                ", $chunk);
    last if @$chunk < $CHUNK_SIZE;
}
$log->out("finish");
