#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'sql',
  webstop => 0,
  db => "ppc",
  when => 'before',
  time_estimate => "1 сек.",
  sql => "RENAME TABLE mfa_checks TO old_mfa_checks, mfa_exceptions TO old_mfa_exceptions",
},
{
  type => 'sql',
  webstop => 0,
  db => "monitor",
  when => 'before',
  time_estimate => "1 сек.",
  sql => [
"CREATE TABLE `mfa_checks` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `url` varchar(1000) NOT NULL,
  `domain` varchar(100) NOT NULL,
  `status` enum('new','checked') default 'new',
  `adv_percent` double default NULL,
  `add_time` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `url` (`url`(255)),
  KEY `domain` (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8",
"CREATE TABLE `mfa_exceptions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `domain` varchar(100) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `domain` (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
",
  ],
},
{
  type => 'script',
  when => 'after',
  time_estimate => "20 сек.",
  comment => "запустить на ppcback01f, 0 строк для mfa_exceptions - это нормально"
}
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;

$log->out("start");
for my $tbl (qw/mfa_exceptions mfa_checks/) {
    my $cnt = do_insert_select_sql(PPC, "INSERT IGNORE INTO $tbl VALUES %s", "SELECT * FROM old_$tbl", dbw => MONITOR);
    $log->out("Moved $cnt rows of $tbl from PPC to MONITOR");
}
$log->out("finish");
