#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "8 часов",
  comment => "удаляет все строки из priorities_context where rank > 0"
}

=cut

use strict;
use warnings;

use Time::HiRes;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;

$log->out("start");
my ($min_prid, $max_prid) = get_one_line_array_sql(PPC, "SELECT min(PriorityID), max(PriorityID) FROM priorities_context");

my $CHUNK = 10_000;
my $SLEEP_COEF = 3;

my $from = $min_prid;
while($from <= $max_prid) {
    my $t = Time::HiRes::time();
    my $rows = do_delete_from_table(PPC, "priorities_context", 
                        where => {
                            rank__gt => 0,
                            PriorityID__between => [$from, $from + $CHUNK - 1]
                         });
    $log->out("  deleted $rows rows from $from");
    $from += $CHUNK;
    Time::HiRes::sleep($SLEEP_COEF * (Time::HiRes::time() - $t));
}
$log->out("finish");
