#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'sql',
  webstop => 0,
  db => "ppc",
  when => 'before',
  time_estimate => "1 сек.",
  sql => "RENAME TABLE metrica_dead_domains TO old_metrica_dead_domains",
},
{
  type => 'sql',
  webstop => 0,
  db => "monitor",
  when => 'before',
  time_estimate => "1 сек.",
  sql => "CREATE TABLE `metrica_dead_domains` (
  `uid` bigint(20) NOT NULL default '0',
  `domain` varchar(100) NOT NULL default '',
  `counter_id` int(10) unsigned NOT NULL default '0',
  `start_time` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `checked_time` timestamp NOT NULL default '0000-00-00 00:00:00',
  `checked` set('Yes','No') NOT NULL default 'No',
  PRIMARY KEY  (`domain`,`uid`,`counter_id`),
  KEY `start_time` (`start_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='list of domains we are giving time to settle in dead state'
",
},
{
  type => 'script',
  when => 'after',
  time_estimate => "3 сек.",
  comment => "запустить на ppcback01f"
}
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;

$log->out("start");
my $cnt = do_insert_select_sql(PPC, "INSERT IGNORE INTO metrica_dead_domains VALUES %s", 
                                    "SELECT * FROM old_metrica_dead_domains",
    dbw => MONITOR
    );
$log->out("Moved $cnt rows of metrica_dead_domains from PPC to MONITOR");
$log->out("finish");
