#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        comment => "удаление ошибочных строк в таблице when_money_on_camp_was",
        time_estimate => '1m 10s'
    }


=cut

=pod description

    В таблицу when_money_on_camp_was попали строки с одинаковыми cid и interval_end и с разными interval_start.
    Т.е. фактически существовало два текущих периода для одной компании.

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use Data::Dumper;

my $for_delete = get_all_sql(MONITOR, "SELECT cid, max(interval_start) as interval_start FROM when_money_on_camp_was WHERE interval_end >= '2038-01-01 00:00:00' GROUP BY cid HAVING count(*) > 1");

for my $row (@$for_delete){
    do_delete_from_table(MONITOR, 'when_money_on_camp_was', where => { cid => $row->{cid}, interval_start => $row->{interval_start} });
}
